/*
   Function: GFValid()
   System:   GRUMPFISH LIBRARY
   Author:   Greg Lief
   Copyright (c) 1988-91, Greg Lief
   Clipper 5.01 Version
   Purpose:  Force total validation of all GETs when user attempts
             to exit the READ
   Syntax:   GFValid(<aGetlist>, <lAllowEscape>)
   Returns:  Nada
   Compile instructions: clipper gfvalid /n/w
*/

#include "grump.ch"
#include "inkey.ch"

function gfvalid(aGets, lAllowEscape)
local nGets := len(aGets)
local x := 0
local ok
local lMainloop := .t.
default lAllowEscape to .f.
// if user escaped out of the READ, there's no need to validate
if lastkey() <> K_ESC
   do while ++x <= nGets .and. lMainloop
      /*
          Loop through GETLIST array and check each one for a VALID clause.
          Note the exitState test -- if this Get has an exitState already
          defined, then it must have already been validated and we therefore
          do not need to test it again here.
      */
      if aGets[x]:exitState == NIL .and. aGets[x]:postBlock <> NIL

         // post this GET object as currently active... necessary because
         // the VALID clause may depend upon GetActive()
         getactive(aGets[x])

         // for the same reasons, post name of the GET object for READVAR()
         // in case VALID function needs it (see GETREADVAR() below...)
         readvar(getreadvar(aGets[x]))

         /*
            If this GET has a WHEN clause, make sure that the WHEN clause
            tests True before proceeding with the rest of the validation.
            Thanks to Kathy Beaumont for spotting this.
         */
         ok := .not. ( aGets[x]:preBlock == NIL .or. ;
                       eval(aGets[x]:preBlock, aGets[x]) )

         /*
            Since it is possible to write a VALID clause that accepts
            the currently active GET object as parameters, we must
            activate each GET object (with the setfocus() method) prior
            to testing the VALID clause. This is to simulate actual
            conditions during the READ, because an active GET has
            certain characteristics that an inactive GET does not (in
            particular, the BUFFER and POS instance variables).
         */
         do while ! ok
            aGets[x]:setfocus()
            ok := eval(aGets[x]:postBlock, aGets[x])
            aGets[x]:killfocus()
            if ! ok
               readmodal( { aGets[x] } )
            endif
            if lAllowEscape .and. lastkey() == K_ESC
               ok := .t.
               lMainloop := .f.   // to force exit from main WHILE loop
            endif
         enddo
      endif
   enddo
endif
return nil


/*
  Function: GetReadVar()
  Excerpted from GETSYS.PRG, which is
  Copyright (c) 1990, 1991 Nantucket Corp.

  The reason I have duplicated it here is because, regrettably, it is a
  static function in GETSYS.PRG, which means that "you can't get there
  from here"
*/
static function getreadvar(get)
local name := Upper(get:name)
local i
if ( get:subscript <> NIL )
   for i := 1 to len(get:subscript)
      name += "[" + ltrim(str(get:subscript[i])) + "]"
   next
endif
return name
