/*
   Program: GFMONTH()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-91, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper gfmonth /n/w/a
*/

#include "grump.ch"

function gfmonth(mdate)
local buffer := substr(set(_SET_DATEFORMAT), 1, 8)
default mdate to date()
do case
   /*
      SET DATE BRITISH and FRENCH have the same date format -- since I
      have more clients in Britain/Australia/Singapore than France,
      English is the default.  If you wish to French instead of English,
      just recompile this PRG with the following command-line syntax:
         clipper gfmonth /dFRENCH
   */
   case buffer == "dd/mm/yy"
      #ifndef FRENCH
         buffer := cmonth(mdate)
      #else
         buffer := {'Janvier', 'Fevrier', 'Mars', 'Avril', 'Mai', 'Juin', ;
                     'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', ;
                     'Decembre' }[month(mdate)]
      #endif

   /* SET DATE GERMAN */
   case buffer == "dd.mm.yy"
      buffer := {'Januar', 'Februar', 'Mrz', 'April', 'Mai', 'Juni', ;
                  'Juli', 'August', 'September', 'Oktober', 'November', ;
                  'Dezember' }[month(mdate)]

   otherwise
      buffer := cmonth(mdate)
endcase
return buffer

* end function GFMonth()
*--------------------------------------------------------------------*

* eof gfmonth.prg
