/*
    Function: GFindGet()
    Purpose:  Locate a GET in the getlist array
    Author:   Greg Lief
    Dialect:  Clipper 5.x
    Copyright (c) 1991 Greg Lief
*/
#include "grump.ch"

function gfindget(victim, getlist)
local ret_val, ele
default getlist to m->getlist
// first verify that GETLIST is a non-empty array
if valtype(getlist) == "A" .and. len(getlist) > 0
   do case

      // if param is character string, search GETLIST for that name
      case valtype(victim) == 'C'
         if (ele := ascan(getlist, { | a | upper(victim) $ upper(a:name) })) > 0
            ret_val := getlist[ele]
         endif

      // if param is numeric, much simpler... range check only
      case valtype(victim) == 'N'
         do case

            // within valid range
            case victim <= len(getlist) .and. victim >= 1
               ret_val := getlist[victim]

            // greater than length of getlist -- return maximum length
            case victim > len(getlist)
               ret_val := atail(getlist)

            // default to 1
            otherwise
               ret_val := getlist[1]
         endcase

      // if no parameter passed, use current GET
      otherwise
         ret_val := getactive()
   endcase
endif
return ret_val

* eof GFINDGET.PRG
