/*
   Program: GFDAY()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-91, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper gfday /n/w/a
*/

#include "grump.ch"

function gfday(mdate)
local buffer := substr(set(_SET_DATEFORMAT), 1, 8)
default mdate to date()
do case
   /*
      SET DATE BRITISH and FRENCH have the same date format -- since I
      have more clients in Britain/Australia/Singapore than France,
      English is the default.  If you wish to French instead of English,
      just recompile this PRG with the following command-line syntax:
         clipper gfday /dFRENCH
   */
   case buffer == "dd/mm/yy"
      #ifndef FRENCH
         buffer := cdow(mdate)
      #else
         buffer := {'Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', ;
                   'Vendredi', 'Samedi' }[dow(mdate)]
      #endif

   /* SET DATE GERMAN */
   case buffer == "dd.mm.yy"
      buffer := {'Sonntag', 'Montag', 'Dienstag', 'Mittwoch', ;
                 'Donnerstag', 'Freitag', 'Samstag' }[dow(mdate)]

   otherwise
      buffer := cdow(mdate)
endcase
return buffer

* end function GFDay()
*--------------------------------------------------------------------*

* eof gfday.prg
