/*
   Function: GFClock()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-91, Greg Lief
   Dialect:    Clipper 5.01
   Syntax:     GFClock( <row>, <column>, <color> )
   Purpose:    Display continuous clock during menu and READ keypress loop
               For more info, see GRUMPR.CH and GRUMPM.CH header files
   Parameters: self-explanatory.  By default, the clock will be
               displayed at the top right corner in the current color.
               If you wish to override these, you should use the EVENT
               clause rather than the CLOCK clause.  For example:

                 MENU TO sel EVENT gfclock(maxrow(), 0, 'W/B')
*/

#include "grump.ch"

function gfclock(nrow, ncol, ccolor)
local r := row(), c := col()
default nrow to 0
default ncol to maxcol() - 7
default ccolor to setcolor()
setpos(nrow, ncol)
dispout(time(), ccolor)
setpos(r, c)
return nil

* end function GFClock()
*--------------------------------------------------------------------*

* eof GFCLOCK.PRG
