/*
    Function: GETDATE()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.01 version
    Compile instructions: clipper getdate /n/w/a

    Procs & Funcs: GETDATE()

          Calls: CALENDBOX()    (function  in CALENDAR.PRG)
               : NEXTMONTH()    (function  in CALENDAR.PRG)
*/

// begin preprocessor directives
#define GRUMP_CALENDAR   // see GRUMP.CH
#include "grump.ch"
#include "inkey.ch"
#define CURRENTYEAR     substr(dtos(mdate), 1, 4)
#define CURRENTDAY      substr(dtos(mdate), 7)

// end preprocessor directives

function getdate(mdate, mtop, mleft, maincolor)
local row
local tdate
local lastday
local newrow
local newcol
local tempdate
local datecoords[10]
local xx
local redraw
local olddelete := set(_SET_DELETED, .T.)
local keypress
local oGet
local ret_val
local nWorkArea
local lHad2Open := .f.
local lHolidays

// note: many people use GETDATE() in conjunction with GRUMPBROW(),
// which remaps the UP and DOWN arrows to do something completely
// different.  Therefore, we will temporarily shut them off so that
// they do what we expect them to do in the context of this function.
local bOldUp   := setkey(K_UP, NIL)
local bOldDown := setkey(K_DOWN, NIL)

// use system date as starting date if it was not passed as parameter
// also see if there is an active GET (used below)
if empty(mdate)
   mdate := date()
   oGet  := getactive()
endif
// determine screen position and color if not passed as parameters
default mtop  to int(maxrow() / 2) - 6
default mleft to int( maxcol() / 2) - 12
default maincolor to ColorSet(C_CALENDAR, .T.)

// only open HOLIDAYS.DBF if it is not already open!
if select("holidays") == 0
   nWorkArea := select()
   if ! file("holidays.dbf")
      dbcreate("holidays.dbf", { { "DATE", "D", 8, 0 } } )
      use holidays new
      index on holidays->date to holidays
      dbclosearea()
      waiton({ "Holiday file empty... you may wish to add data" } )
      inkey(5)
      waitoff()
      lHolidays := .f.
   else
      lHolidays := lHad2Open := net_use('holidays', .f., 'holidays')
   endif
   select (nWorkArea)
else
   lHolidays := .t.
endif

GFSaveEnv( { mtop, mleft, mtop + 13, mleft + 23 }, 0 )  // shut off cursor
CalendBox(.f., mtop, mleft, mdate, maincolor, .t., datecoords)
do while keypress != K_ENTER .and. keypress != K_ESC
   redraw := .f.
   keypress := ginkey(0)
   tdate := mdate                  && store highlighted date
   newrow := CURRENTDAY_ROW
   newcol := CURRENTDAY_COL
   do case

   case keypress == K_DOWN .or. keypress == K_UP   // forward/backward one week
      mdate += if(keypress = 24, 7, -7)
      newrow  += if(keypress = 24, 1, -1)

   case keypress == K_LEFT         // go back one day
      mdate--
      // did we just go from sunday to saturday??
      newrow := if(dow(mdate) = 7, CURRENTDAY_ROW - 1, CURRENTDAY_ROW)
      newcol := if(dow(mdate) = 7, mleft + 19, CURRENTDAY_COL - 3)

   case keypress == K_RIGHT       // go forward one day
      mdate++
      // did we just go from saturday to sunday??
      newrow := if(dow(mdate) = 1, CURRENTDAY_ROW + 1, CURRENTDAY_ROW)
      newcol := if(dow(mdate) = 1, mleft + 1, CURRENTDAY_COL + 3)

   case keypress == K_PGUP        // go back one month
      if month(mdate) == 1        // going to December of previous year
         mdate := stod( str(val(CURRENTYEAR)-1, 4) + '12' + CURRENTDAY)
      else
         // check for validity of current date in previous month
         // i.e., cannot go from march 31 to february 31, etcetera
         tempdate := ctod('')
         do while empty(tempdate)
            tempdate := stod(CURRENTYEAR + if(month(mdate) < 11, '0', '') + ;
                        ltrim(str(month(mdate) - 1)) + CURRENTDAY)
            mdate--
         enddo
         mdate := tempdate
      endif

   case keypress == K_PGDN        // go forward one month
      mdate := NextMonth(mdate)

   case keypress == K_HOME        // go to first day
      newrow := FIRSTDAY_ROW
      newcol := FIRSTDAY_COL
      mdate := stod(substr(dtos(mdate), 1, 6) + '01')

   case keypress == K_END         // go to last day
      newrow := LASTDAY_ROW
      newcol := LASTDAY_COL
      mdate := stod(substr(dtos(mdate), 1, 6) + str(LASTDAY_NUMBER, 2))

   otherwise                  // any other keystroke
      loop

   endcase
   // if we changed months, redraw calendar
   if month(tdate) != month(mdate) .or. redraw
      CalendBox(.f., mtop, mleft, mdate, maincolor, , datecoords)
   else
      // check if previous date was a holiday
      if lHolidays .and. holidays->( dbseek(tdate) )
         @ CURRENTDAY_ROW, CURRENTDAY_COL ssay str(day(tdate), 2) color 'w/r'
      else
         @ CURRENTDAY_ROW, CURRENTDAY_COL ssay str(day(tdate),2) ;
                                          color '+' + maincolor
      endif

      // check if new date is a holiday
      if lHolidays .and. holidays->( dbseek(mdate) )
         @ newrow, newcol ssay str(day(mdate), 2) color '*+w/r'
      else
         @ newrow, newcol ssay str(day(mdate), 2) color '*+' + maincolor
      endif

      // store new row/column coordinates for highlighted date
      CURRENTDAY_ROW := newrow
      CURRENTDAY_COL := newcol
   endif
enddo
GFRestEnv()
// close HOLIDAYS.DBF if we had to open it
if lHad2Open
   holidays->( dbCloseArea() )
endif
set(_SET_DELETED, olddelete)  // reset previous DELETED status
setkey(K_UP, bOldUp)
setkey(K_DOWN, bOldDown)
if keypress == K_ENTER
   ret_val := mdate
   // if no parameter was passed and there is an active GET,
   // manipulate it directly (this gets us around the problem
   // of passing by reference)
   if oGet != NIL
      oGet:varPut( mdate )
   endif
else
   ret_val := ctod('')
endif
return ret_val

* end function GetDate()
*--------------------------------------------------------------------*

* eof getdate.prg
