/*
   Function: FOTOCOPY()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-93, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper fotocopy /n /w
   Inspired by Gary Van Slyke, Minneapolis, MN
*/

#include "dbstruct.ch"

static aFields := {}
static nSourceArea

/*
   Function: FotoCopy()
   Purpose: get the ball rolling
*/
function fotocopy(cAlias1, cAlias2, cAlias3, cAlias4)
local nFiles := pcount()
local nRetVal := 0
local xx
aFields := dbstruct()      // dump current .dbf structure to array
nSourceArea := select()
for xx := 1 to nFiles
   nRetVal += loopdloop(if(xx == 1, cAlias1, if(xx == 2, cAlias2, ;
                        if(xx == 3, cAlias3, cAlias4))))
next
return nRetVal

* end function FotoCopy()
*--------------------------------------------------------------------*


/*
   Function: LoopDLoop()
   Purpose: Main loop to copy record into each database
*/
static function loopdloop(cAlias)
local aFields2
local lFirstLoop := .t.
local xx
local nRetVal := 1
local nElement
local lHad2Open := .f.
local nFields
local cfield

// determine whether target database is already open
if select(cAlias) == 0
   if ! net_use(cAlias, .f.)
      nRetVal := 0
   else
      select (nSourceArea)
      lHad2Open := .t.
   endif
endif

if nRetVal == 1
   nFields := (cAlias)->( fcount() )
   aFields2 := (cAlias)->( dbstruct() )
   for xx := 1 to nFields
      // check if this field is in the source database
      if (nElement := ascan(aFields, ;
                      { |a| a[DBS_NAME] == aFields2[xx][DBS_NAME] } )) > 0
         // verify they are of the same type!
         if aFields2[xx][DBS_TYPE] == aFields[nElement][DBS_TYPE]
            if lFirstLoop
               (cAlias)->( add_rec() )
               lFirstLoop := .f.
            endif
            cField := aFields2[xx][DBS_NAME]
            (cAlias)->( fieldput((cAlias)->(fieldpos(cField)), ;
                        (nSourceArea)->(fieldget(fieldpos(cField)))) )
         endif
      endif
   next
   if lHad2Open
      (cAlias)->( dbCloseArea() )
   endif
endif
return nRetVal

* end static function LoopDLoop()
*--------------------------------------------------------------------*

* eof fotocopy.prg
