/*
    Program: FILELOCK()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper filelock /n /w /a

    Attempts to lock file in multi-user environment
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives

function filelock
local box_no, buffer, firstloop, ret_val := .f., waitmsg, oldscrn, key := 0
if len(alias()) > 0   // hey, must have a database in use, eh Joe?
   waitmsg := alias() + '.dbf'   // used in kaleidoscope if user decides to wait
   firstloop := .t.
   do while key != K_ESC .and. ! ret_val
      if flock()
         ret_val := .t.
      elseif firstloop
         firstloop := .f.
         if yes_no('Cannot lock ' + waitmsg + ' at this time', ;
                   'Would you like to wait')
            oldscrn := savescreen(0, 0, maxrow(), maxcol())
            kaleid(.t., waitmsg)
         else
            exit
         endif
      else
         kaleid(.f., waitmsg)
         key := lastkey()
      endif
   enddo
   if ! firstloop
      restscreen(0, 0, maxrow(), maxcol(), oldscrn)
      if ret_val    // file locked successfully - give user aural feedback
         CHARGE
      endif
   endif
endif
return (ret_val)

* end function FileLock()
*--------------------------------------------------------------------*

* eof filelock.prg
