/*
   Program: FALLGUY()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper fallguy /n/w/a
*/

#include "grump.ch"

function fallguy(mrow, mcol, msg, delay)
local nrow, ncol, cbuffer, xx, ntone, oldcurs := setcursor(0)
if mrow != NIL .and. mcol != NIL .and. msg != NIL
   //----- establish starting tone based on row and length of message
   ntone := mrow / 3 * len(msg) * 50 + 150
   for ncol = mcol to mcol + len(msg) - 1
      if substr(msg, ncol - mcol + 1, 1) != chr(32)
         for nrow = 0 to mrow
            //----- save the screen coordinate that is about to be erased
            cbuffer := savescreen(nrow, ncol, nrow, ncol)
            //----- draw falling letter at that location
            @ nrow, ncol ssay substr(msg, ncol - mcol + 1, 1)
            if delay == NIL       // if no delay passed, use 'twinkle-tones'
               if nrow % 3 == 0   // only sound off at every 3rd row
                  tone(ntone -= 50, 1)
               endif
            else
               for xx = 1 to delay
               next
            endif
            if nrow < mrow
               // restore affected portion of screen
               restscreen(nrow, ncol, nrow, ncol, cbuffer)
            endif
         next
      else   // a falling space would look pretty stupid, at least to me
         @ mrow, ncol ssay chr(32)
      endif
   next
endif
setcursor(oldcurs)
return NIL

* end function FallGuy()
*--------------------------------------------------------------------*

* eof fallguy.prg
