/*
   Function: FadeOut()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper fadeout /n/w/a

   Syntax: FadeOut(<filename>)

   Parameter: <filename> is a character string representing the name
              of the file in which the random coordinates were saved.

   Returns: Nada
*/

// begin preprocessor directives

#include "fileio.ch"
#include "grump.ch"

// end preprocessor directives

function fadeout(cfile)
local nhandle := fopen(cfile, FO_READ), xx, ret_val := .f., ;
      filesize := (maxrow() + 1) * (maxcol() + 1), buffer := space(2)
if nhandle > -1
   // verify that this file was saved in the same mode that we are in
   // because if it wasn't, all hell will break loose further down
   if fseek(nhandle, 0, FS_END) == filesize * 2
      fseek(nhandle, 0, FS_SET)       // reset to start of file
      ret_val := .t.
      for xx = 1 to filesize
         fread(nhandle, @buffer, 2)
         @ bin2i(substr(buffer, 1, 1)), bin2i(substr(buffer, 2, 1)) ssay [ ]
      next
   endif
   fclose(nhandle)
endif
return ret_val

* end function FadeOut()
*--------------------------------------------------------------------*

* eof fadeout.prg
