/*
    Function: FadeIn()
    System:   GRUMPFISH LIBRARY
    Author:   Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper fadein /n/w/a

    Syntax: FadeIn(<filename>)

    Parameter: <filename> is a character string representing the name
               of file in which the screen was saved with Sv_FadeIn().

    Returns: A logical value: .T. if successful, .F. if unsuccessful
             (the only way I can see it failing is if there are not
             enough available file handles to open the screen file)
*/

// begin preprocessor directives

#include "fileio.ch"

// end preprocessor directives

function fadein(cfile)
local nhandle := fopen(cfile, FO_READ), nrow, ncol, buffer := space(2), ;
      xx, ret_val := .f., filesize := (maxrow() + 1) * (maxcol() + 1)
if nhandle > -1
   // verify that this file was saved in the same mode that we are in
   // because if it wasn't, all hell will break loose further down
   if fseek(nhandle, 0, FS_END) == filesize * 4
      fseek(nhandle, 0, FS_SET)       // reset to start of file
      ret_val := .t.
      nrow := ncol := space(1)
      for xx = 1 to filesize
         fread(nhandle, @nrow, 1)
         fread(nhandle, @ncol, 1)
         fread(nhandle, @buffer, 2)
         restscreen(bin2i(nrow), bin2i(ncol), bin2i(nrow), bin2i(ncol), buffer)
      next
   endif
endif
fclose(nhandle)
return ret_val

* end function FadeIn()
*--------------------------------------------------------------------*

* eof fadein.prg
