/*
    Program: EXPBOX()
    System:  GRUMPFISH LIBRARY
    Author:  Greg Lief w/ special thanks to Mike Clerc
    Copyright (c) 1990, Grumpfish Inc.
    Clipper 5.01 Version
    Compile instructions: clipper explode /n/w/a

    Draws exploding box and saves array for TRUE implosion
    5.0 NOTES: you need not pass an array name as a parameter!
    Syntax: ExpBox(<top>, <left>, <bottom>, <right>,
            [<style>, <speed>, <color>, <title>, <footer>])

          Calls: Box_Title()   (Function in BOXTITLE.PRG)
                 GfAttr()      (ASM Function in GRUMPATT.ASM)
*/

#include "grump.ch"

static boxstack_ := {}

function expbox(ntop, nleft, nbottom, nright, ntype, ndelay, mcolor, ;
                ctitle, cfooter)
local seed1, seed2, mtop, mleft, mbottom, mright, xx, boxstring, ;
      kounter := 1, boxarray_ := {}, tbottom, tright
default ntop to 0
default nleft to 0
default nbottom to maxrow()
default nright to maxcol()
if nbottom > maxrow() .or. nright > maxcol()  ;
        .or. ntop > nbottom .or. nleft > nright
   return -1
endif
GFSaveEnv()
default ntype to 1
default ndelay to 35
default ctitle to ''
// limit border # to 6 to avoid array crash
boxstring := BOXFRAMES[if(ntype > 6, 1, ntype)]
seed1 := int((nbottom - ntop) / 2)
seed2 := int((nright - nleft) / 2)
mtop := mbottom := ntop + seed1
mleft := mright := nleft + seed2
kounter := 1
// establish TBOTTOM and TRIGHT, to ensure that savescreen() does not
// go beyond the maxrow() and maxcol() limits
tbottom := min(nbottom + 2, maxrow())
tright  := min(nright + 2, maxcol())
aadd(boxarray_, { ntop, nleft, tbottom, tright } )
aadd(boxarray_, savescreen(ntop, nleft, tbottom, tright) )
if ndelay > 1
   do while (mtop > ntop .and. mleft > nleft) .and. ;
            (mbottom < nbottom .and. mright < nright)
      @ mtop, mleft, mbottom, mright box boxstring color mcolor
      aadd(boxarray_, savescreen(ntop, nleft, tbottom, tright))
      for xx = 1 to ndelay
      next
      mtop--
      mleft -= (seed2 / seed1)
      mbottom++
      mright += (seed2 / seed1)
   enddo
endif
// draw shadow if coordinates are valid
if nbottom < maxrow() .and. nright < maxcol() - 1
   gfattr(ntop + 1, nright + 1, nbottom + 1, nright + 2, 8)
   gfattr(nbottom + 1, nleft + 2, nbottom + 1, nright + 2, 8)
endif
@ ntop, nleft, nbottom, nright box boxstring color mcolor

// draw title if requested
if len(ctitle) > 0
   box_title(ntop, nleft, nright, ctitle, boxstring, .f., mcolor)
endif

// draw footer if requested
if cfooter != NIL
   box_title(nbottom, nleft, nright, cfooter, boxstring, .f., mcolor)
endif

GFRestEnv()
// add this array of saved screens to the window stack
aadd(boxstack_, boxarray_)
return len(boxstack_)

* end function ExpBox()
*--------------------------------------------------------------------*


/*
   Program: IMPBOX()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief w/ thanks to Mike Clerc
   Copyright (c) 1990, Grumpfish Inc.
   Implodes a previously-exploded box
   Syntax: ImpBox([<speed>])
*/

#define TOP    boxarray_[1, 1]
#define LEFT   boxarray_[1, 2]
#define BOTTOM boxarray_[1, 3]
#define RIGHT  boxarray_[1, 4]

function impbox(ndelay)
local xx, yy, zz, boxarray_
if len(boxstack_) > 0   // preclude crash on empty array
   boxarray_ := atail(boxstack_)
   default ndelay to 35
   yy := len(boxarray_)
   for xx = yy to 2 step -1
      restscreen(TOP, LEFT, BOTTOM, RIGHT, boxarray_[xx])
      for zz = 1 to ndelay
      next
   next
   // decrease the size of the window stack by one element
   truncate(boxstack_)
endif
return NIL

* end function ImpBox()
*--------------------------------------------------------------------*

* eof explode.prg
