/*
   Program: EXBOX()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper exbox /n/w/a
   Draws exploding box
   Calls: BOX_TITLE()      (Function in FBOXTIT.PRG)
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function exbox(ntop, nleft, nbottom, nright, ntype, ndelay, cfill, ;
               lshadow, ctitle, lcrossbar, cfooter)
local medver, medhor, dom, x, y, ttop, tbottom, tleft, tright, ret_val, ;
      boxstring
// establish defaults if not passed
default ntop to 0
default nleft to 0
default nbottom to maxrow()
default nright to maxcol()
default cfill to chr(32)
default lshadow to .f.
default ctitle to []

// limit border to 6 to avoid array crash
if ntype > 6
   ntype := 1
endif
lcrossbar := (lcrossbar != NIL)

// if they passed a null string for the fill character, make it a space
cfill := if(len(cfill) == 0, chr(32), cfill)

// construct array containing coordinates & contents of screen
// area underneath this box - this can be used with byebyebox()
ret_val := { ntop, nleft, nbottom + if(lshadow, 1, 0), ;
             nright + if(lshadow, 2, 0), savescreen(ntop, nleft, ;
             nbottom + if(lshadow, 1, 0), nright + if(lshadow, 2, 0)) }
boxstring := substr(BOXFRAMES[ntype], 1, 8) + cfill + ;
             substr(BOXFRAMES[ntype], 10, 4)
if iscolor() .and. ndelay > 0         // color monitor for full effect
   medver := int(((nbottom - ntop) + 1) / 2)   // determine vertical median
   medhor := int(((nright - nleft) + 1) / 2)   // determine horizontal median
   dom := max(medver, medhor)
   // determine dynamic box coordinates
   ttop := ntop + medver
   tbottom := nbottom - medver
   tleft := nleft + medhor
   tright := nright - medhor

   // main loop -- draw box out from center
   for x = 1 to dom
      @ ttop, tleft, tbottom, tright box boxstring
      for y = 1 to ndelay              // slow down explosion as desired
      next

      // test for border and expand if required
      if x < medver
         ttop--
         tbottom++
      endif
      if x < medhor
         tleft--
         tright++
      endif
   next
endif

// draw shadow if called for and coordinates are valid
if lshadow .and. iscolor() .and. nbottom < maxrow() .and. nright < maxcol()-1
   gfattr(ntop + 1, nright + 1, nbottom + 1, nright + 2, 8)
   gfattr(min(nbottom + 1, maxrow()-1), nleft + 2, nbottom + 1, nright + 2, 8)
endif

// draw outer box border
@ ntop, nleft, nbottom, nright box boxstring

// draw title if requested
if len(ctitle) > 0
   box_title(ntop, nleft, nright, ctitle, boxstring, lcrossbar)
endif

// draw footer if requested
if cfooter != NIL
   box_title(nbottom, nleft, nright, cfooter, boxstring, .f.)
endif

return (ret_val)

* end function ExBox()
*--------------------------------------------------------------------*

* eof exbox.prg
