/*
    Program: ERR_MSG()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper errmsg /n/w/a

    Displays error message and waits for user keypress
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function err_msg(msgs, boxcolor, textcolor, sound, ctitle)
local oldscrn, x := 0, mlen, leftcol
GFSaveEnv(, 0)                   // shut off cursor

// establish box and text colors if not passed as parameters
default boxcolor to ColorSet(C_ERRORBOX, .t.)
default textcolor to ColorSet(C_ERRORMESSAGE, .t.)
default sound to .t.
default ctitle to "Error"

// if message passed was a character string, convert to array
if valtype(msgs) == "C"
   msgs := { msgs }
endif

// add keypress msg to array
aadd(msgs, "** press any key to continue **")
mlen := len(msgs)

// determine width of longest message in array
aeval(msgs, { | a | x := max(len(a), x) } )

leftcol := int(maxcol() - 5 - max(x, 35)) / 2
setcolor(boxcolor)
oldscrn := shadowbox(10, leftcol, 11 + mlen, maxcol() - leftcol, 3, ctitle)
setcolor(textcolor)
for x = 1 to mlen
   SCRNCENTER(10 + x, msgs[x])
next
if sound
   tone(MUSIC_ERROR, 1)
   tone(MUSIC_ERROR, 1)
endif
ginkey(0)
GFRestEnv()
byebyebox(oldscrn)
return nil

* end function Err_Msg()
*--------------------------------------------------------------------*

* eof errmsg.prg
