/*
    Program: DRAPES.PRG
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper drapes /n/w/a

    Procs & Fncts: PULL_DRAPE()
                 : SAVE_DRAPE()
*/

// begin preprocessor directives

#include "grump.ch"
#include "fileio.ch"

// end preprocessor directives

/*
   Function: PULL_DRAPE()
   Purpose:  Draw title screen from specified memory file
*/
function Pull_Drape(cfile, ndelay)
local nhandle, screen_ := {}, buffer := space(4), xx, yy, midpoint, ;
      ntop := 0, nleft := 0, nbottom := maxrow(), nright := maxcol(), mwidth, ;
      mlength, oldcurs := setcursor(0)
default ndelay to 20
if file(cfile)
   nhandle := fopen(cfile, FO_READ)
   // determine file length
   mlength := fseek(nhandle, 0, FS_END)
   // reset pointer to beginning of file
   fseek(nhandle, FS_SET)
   // we must accommodate for .scr files created by
   // if this is not a full screen
   if mlength != 4000
      fread(nhandle, @buffer, 4)
      ntop    := bin2i(substr(buffer, 1, 1))
      nleft   := bin2i(substr(buffer, 2, 1))
      nbottom := bin2i(substr(buffer, 3, 1))
      nright  := bin2i(substr(buffer, 4, 1))
   endif
   mwidth := ((nbottom - ntop) + 1) * 2
   yy := nright - nleft + 1
   asize(screen_, yy)
   for xx = 1 to yy
      buffer := space(mwidth)
      fread(nhandle, @buffer, mwidth)
      screen_[xx] := buffer
   next
   fclose(nhandle)
   midpoint := nleft + int((nright - nleft + 1) / 2) + 1
   for xx = midpoint to nright + 1
      restscreen(ntop, xx - 1, nbottom, xx - 1, screen_[xx - nleft])
      restscreen(ntop, nright + 1 + nleft - xx, nbottom, ;
                 nright + 1 + nleft - xx, screen_[nright + 2 - xx])
      for yy = 1 to ndelay
      next
   next
endif
setcursor(oldcurs)
return NIL

* end function Pull_Drape()
*--------------------------------------------------------------------*


/*
     Function: SAVE_DRAPE()
     Purpose:  Save title screen to specified memory file
*/
function save_drape(cfile, ntop, nleft, nbottom, nright)
local buffer, nhandle := fcreate(cfile), xx, ret_val := .f.
default ntop to 0
default nleft to 0
default nbottom to maxrow()
default nright to maxcol()
if ferror() = 0
   fwrite(nhandle, chr(ntop) + chr(nleft) + chr(nbottom) + chr(nright))
   ret_val := .t.
   for xx = nleft to nright
      buffer := savescreen(ntop, xx, nbottom, xx)
      if fwrite(nhandle, buffer) != ((nbottom - ntop) + 1) * 2
         ret_val := .f.
         exit
      endif
   next
   fclose(nhandle)
endif
return ret_val

* end function Save_Drape()
*--------------------------------------------------------------------*

* eof drapes.prg
