/*
   Grumpfish Library 5.0 demo
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Compile instructions: clipper demo /n/w/a
*/

#include "apick.ch"
#include "grump.ch"
#include "grumpbro.ch"
#include "grumpr.ch"
#include "grumpm.ch"
#include "inkey.ch"

#define PRIMARY_COLOR    "W/RB"

// next two statics are used for highlighting info during GETSYS demo
static ptr
static verbiage_ := { ;
[@ 14,0 gget v math message "Enter a math formula"], ;
[@ 15,0 gget y calculator picture '#####.##' message "Right-to-left entry"], ;
[@ 16,0 gget team list teams message "Use spacebar or backspace to toggle"], ;
[@ 17,0 gget w step color 'n/bg,+w/r' message "Use + and - keys"], ;
[@ 18,0 gget pass1 message "Enter a password" password "?"], ;
[@ 19,0 gget pass2 message "Enter a password" password], ;
[@ 20,0 gget z proper message "This will be proper-case"], ;
[@ 21,0 gget x array days picture '@!' message "Please pick a day!"] }

function main(skip_it)
external soundex, helpdev
local x, selected, maincolor, mfile := '!!!!!!!!.!!!', mrow, ;
      mtone, any_key, msg := "The Grumpfish Library"
setblink(.f.)
colorinit('colors.gf')
setcursor(0)
set scoreboard off
set wrap on
SAVE_DRAPE(mfile)
selected := 'i'
if skip_it == NIL
   setcolor('+W/N')
   scroll()
   Fallguy(03, 29, msg, 100)
   SCRNCENTER(maxrow(), 'Press space bar for demo or Esc for DOS', '+BR/N')
   rainbow(msg)
   if lastkey () != K_ESC
      lets_go()
   ENDif
else
   lets_go()
endif
dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), "I")
setcolor('W/BR')
expbox(1, 6, 23, 73, 1, 30)
setcolor('+W/BR')
rollup("Grumpfish Library is written 99.99% in Clipper.  You get two")
rollup("versions of the source code: one for Summer '87, and another")
rollup("FULLY OPTIMIZED for Clipper 5.01. You also get a no-nonsense")
rollup("royalty-free integration license, easy-to-read documentation,")
rollup("one year free BBS technical support on the Grumpfish BBS (a")
rollup("worldwide haven for Clipper expertise), and thirty days free")
rollup("voice support.  Our '                   ' guarantee: if you are")
rollup("not absolutely tickled pink by Grumpfish, return it within 30")
rollup("days from your date of purchase for a full and courteous refund!")
rollup('')
rollup('Grumpfish Library is available for just $199 (shipping: $7.50')
rollup("US/Canada, $20 overseas).  Order NOW by calling (503) 588-1815")
rollup("or fax your order to (503) 588-1980.  MC/VISA/AMEX accepted.")
rollup('')
rollup(SPACE(20) + 'Grumpfish, Incorporated')
rollup(SPACE(20) + 'Post Office Box 17761')
rollup(SPACE(20) + 'Salem, Oregon 97305 USA')
rollup('')
rollup('')
rollup(space(5) + "Tel +44 81 994 4842" + space(16) + "Tel 089 570 6031")
rollup(space(5) + "Fax +44 81 994 3441" + space(16) + "Fax 089 570 7631")
setcolor('+GR/BR')
@ 4,8 SAY 'FULLY OPTIMIZED'
@ 8,29 SAY 'No Grumpy Customers'
@ 13,56 say "(503) 588-1815"
@ 14,29 say "(503) 588-1980"
@ 20,16 say "United Kingdom" color 'i'
@ 20,52 say "Germany" color 'i'
inkey(20)
impbox(60)
ferase('help.dbf')
ferase('help.cfg')
ferase('help.dbt')
ferase('help' + indexext())
ferase('demo2.scr')
ferase('demo3.scr')
set color to
any_key='fadeback.scr'
if file(any_key)
   fadein(any_key)
else
   blindopen(mfile)
endif
ferase(mfile)
ferase('gftemp.dbf')
setblink(.t.)
devpos(maxrow(), 0)
return nil


function lets_go
local xx, any_key, mfile, screens := {}, sel := 1, dumbo, mstate, thefiles, ;
      mainmenu, buff, maincolor := if(Iscolor(), 'w/b', 'w/n'), mvar,   ;
      menulist, getcolor, mdate, mnum, mpassword, mstring, mliststring, ;
      mnum2
memvar getlist
local v, w, x, y, z, pass1, pass2, oldf1, team, teams, tags_
static days := { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" }
static lookup_ := { { "ABCD", "A Better Code Dollop" } , ;
                    { "WXYZ", "Where's Xenia's Young Zoo?" } , ;
                    { "GYRH", "Get Yer Red Hots" } , ;
                    { "WITW", "What In The World!?" } , ;
                    { "NOYH", "Newsprint On Your Hands" } , ;
                    { "TMNB", "This Means Nothing, Bucko" } , ;
                    { "YACA", "Yet Another Cryptic Acronym" } , ;
                    { "DNGC", "Definitely No Grumpy Customers!" } , ;
                    { "PTYF", "Please Tell Your Friends" } , ;
                    { "TSFR", "This Space For Rent" } }
local testdata_ := { ;
      { "Greg", "Lief", "503-588-1815", '', '503-588-1980', '', "Grumpfish, Inc.", ;
        "2450 Lancaster Dr., NE", "Salem", "OR", "97305", .t.}, ;
      { "Jennifer", "Lief", "503-588-1815", '', '503-588-1980', '', "Grumpfish, Inc.", ;
        "2450 Lancaster Dr., NE", "Salem", "OR", "97305", .t.}, ;
      { "Mary", "Gries", "503-588-1815", '', '503-588-1980', '', "Grumpfish, Inc.", ;
        "2450 Lancaster Dr., NE", "Salem", "OR", "97305", .t.}, ;
      { "Mark", "Worthen", "503-588-1815", '', '503-588-1980', '', "Grumpfish, Inc.", ;
        "2450 Lancaster Dr., NE", "Salem", "OR", "97305", .t.}, ;
      { "Albert", "Albertson", "208-331-1234", '', '', '', "Albertson's", ;
        "123 Main Street", "Boise", "ID", "83811", .t.}, ;
      { "Adam", "Lief", "202-234-7172", '', '', '', "Club Zeophyte", ;
        "4 F Street, NW", "Washington", "DC", "20005", .t.} }

// additional options menu used by Grumpbrow()
local moreopts_ := { ;
      { "First extra option",   { | b | dummy(1, b) } }, ;
      { "Second extra option",  { | b | dummy(2, b) } }, ;
      { "Third extra option",   { | b | dummy(3, b) } }, ;
      { "Fourth ~extra option", { | b | dummy(4, b) } }, ;
      { "Last extra option",    { | b | dummy(5, b) } }  ;
                   }

dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), maincolor)
set message to 24
set key K_F1 to helpdev
Shadowbox(0,0,4,16,6,,,'w/r')
@ 1,1 say 'Press F1 to' color '+w/r'
@ 2,1 say 'make your own' color '+w/r'
@ 3,1 say 'help screen!' color '+w/r'
if ! file('demo.scr')
   save_drape('demo.scr')
endif
/*
   create phone database if it doesn't already exist - we will
   need this for GrumpBrow(), POPNOTE, and SETFILT
*/
if ! file('phone.dbf')
   dbcreate("phone.dbf",    { {"FNAME",   "C", 15, 0} , ;
                              {"LNAME",   "C", 15, 0} , ;
                              {"PHONE_NO","C", 12, 0} , ;
                              {"EXT",     "C",  4, 0} , ;
                              {"FAX",     "C", 12, 0} , ;
                              {"MOBILE",  "C", 12, 0} , ;
                              {"COMPANY", "C", 20, 0} , ;
                              {"ADDRESS", "C", 25, 0} , ;
                              {"CITY",    "C", 15, 0} , ;
                              {"STATE",   "C",  2, 0} , ;
                              {"ZIP",     "C", 10, 0} , ;
                              {"LONGDIST","L",  1, 0} } )
   use phone
   //----- add dummy records
   for x := 1 to 6
      append blank
      for y := 1 to 12
         fieldput(y, testdata_[x][y])
      next
   next
   use
endif
if ! file('phone' + indexext())
   use phone
   index on upper(phone->lname + phone->fname) to phone
   use
endif
colorset(PRIMARY_COLOR)
shadowbox(2, 31, 19, 48, 2)
shadowbox(maxrow()-2, 25, maxrow(), 53, 2)
do while sel != 0 .and. sel != 16
   /*
      these @..PROMPTS and MENU TO are preprocessed into calls to the
      Grumpfish LITE_MENU2() function, which permits highlighted and/or
      alternate trigger letters, and different colors for each message!
   */
   @3,32 prompt "Calculator      " message "  Useful pop-up calculator "
   @4,32 prompt "Spreadsheet     " message "Automatic recalculation etc" ;
                                   triggercolor "N/BG" messagecolor "+W/RB"
   @5,32 prompt "Notepad         " message "  Notepad with mail merge  "
   @6,32 prompt "Phone Directory " message "Wonderful magnetic rolodex "
   @7,32 prompt "Calendar/~Appts  " message "Calendar/appointments etc. "
   @8,32 prompt "Stop~Watch       "      message "Pop-up background stopwatch"
   @9, 32 prompt "Filter Builder  " message "   User-definable filters  "
   @10,32 prompt "Grump~Brow()     " message "Awesome database browser!!!" ;
                                  triggercolor "N/BG" messagecolor "+W/RB"
   @11,32 prompt "View PHONE.PRG  " message "Code generated by GrumpBrow"
   @12,32 prompt "Grump's GETSYS  " message "Explore new Grumpfish GETs "
   @13,32 prompt "Bo~x Tricks      "    message "Exploding/imploding/etc...."
   @14,32 prompt "String Tricks   "  message "Falling/spreading/teletypes"
   @15,32 prompt "Screen Tric~ks   " message "Peeling/folding/splitting.."
   @16,32 prompt "User Feedback   "  message "Many other useful functions"
   @17,32 prompt "Color ~Management" message "Hooray for static arrays!!!"
   @18,32 prompt "Exit            "           message "Leaving so soon?  Boo hoo!!"
   menu to sel initial sel event gfclock(,,'w/b') timeout 30 ;
               noclear_messages messagerow maxrow() - 1
   mainmenu := savescreen(0, 0, maxrow(), maxcol())
   do case

   case sel == 1
      popcalc()

   case sel == 2
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), maincolor)
      colorset(C_MESSAGE)
      expbox(0, 1, 8, maxcol() - 2, 1, 10, , "GrumpCalc()")
      @ 1, 3 say 'GrumpCalc() is a full-featured miniature spreadsheet that you can pop up'
      @ 2, 3 say 'within a numeric GET.  Press F1 from within the GET below to pop up the'
      @ 3, 3 say 'spreadsheet.  Within the spreadsheet, do some calculations to derive a'
      @ 4, 3 say 'value.  Then press ESC to return to the GET.  Your final value will be'
      @ 5, 3 say 'pasted into the GET!'
      @ 7, 3 say 'If you need help on active keys in the spreadsheet, press F1.'
      w := 0
      oldf1 := setkey(K_F1, { |p,l,v| grumpcalc(p, l, v) } )
      colorset(maincolor)
      @ 11, 10 say "This is a numeric GET - press F1" get w
      setcursor(1)
      read
      setcursor(0)
      setkey(K_F1, oldf1)
      impbox(50)

   case sel == 3
      use phone new
      popnote()
      use

   case sel == 4
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), maincolor)
      popphone()

   case sel == 5
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), "I")
      popdate()

   case sel == 6
      popstop()

   case sel == 7 .or. sel == 8
      use phone new
      setcolor(maincolor)
      if sel == 7
         dbsetindex('phone')
         Setfilt()
      else
         indexbar('company')
         dbsetindex('phone')
         dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), maincolor)
         colorset(C_MESSAGE)
         exbox(0, 1, 10, maxcol() - 2, 6, 5, '', .t.)
         @ 0, 2 say 'GrumpBrow is the last word in generic database browsers.  For starters, it'
         @ 1, 2 say 'includes automatic add/edit/view/delete/QBE/search/output routines.  You '
         @ 2, 2 say 'determine what features are active simply by passing the first letter of '
         @ 3, 2 say 'each option. You can also view data subsets with ALT-S, switch indeces with'
         @ 4, 2 say 'ALT-I, lock columns with L, pass an additional options menu as a parameter'
         @ 5, 2 say '(press ALT-F10 to see it, and check the demo source code for more info).'
         @ 6, 2 say 'It also includes a screen painter/code generator.  Press "P" to quickly '
         @ 7, 2 say 'design your data entry screen.  You can move and delete fields, add static '
         @ 8, 2 say 'text, draw boxes, change colors.  (For a complete list of commands, press'
         @ 9, 2 say 'F1 while in the screen painter.)  When finished, press shift-F10 to generate'
         @10, 2 say 'fully-optimized 5.01 code that you can drop in your application immediately!'
         inkey(1)
         /*
            Notes: VBLOCK is a code block that will be evaluted upon
                   any vertical movement in the Grumpbrow() window.
                   EXTRA allows you to pass in an array containing
                   additional menu options.  This menu can be popped
                   up with the ALT-F10 key (but you can override
                   this key by using the EXTRAKEY parameter).
         */
         grumpbrow security 'oiflaedvqsp' top 11 lock 2 ;
                   vblock { | b | showrecno(b) } extra moreopts_
      endif
      close data

   case sel= 9
      if file( mfile := "phone.prg" )
         Shadowbox(0, 0, maxrow(), maxcol(), 2, ;
                   'Viewing GrumpBrow() code', , 'w/rb')
         setcolor('+w/rb')
         memoedit(memoread(mfile), 1, 1, maxrow() - 1, maxcol() - 1, .f.)
      else
         err_msg( { mfile + ;
                   ' not found -- visit the GrumpBrow() screen painter' } )
      endif

   case sel == 10
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), 'n/bg')
      colorset(C_MESSAGE)
      expbox(0, 2, 10, 76, 1, 30, setcolor(), "Grumpfish GETSYS")
      @ 1, 7 say "Here is the source code for the GETs at the bottom of the screen"
      aeval(verbiage_, { | text | setpos(row()+1, 3), dispout(text) } )
      ptr := 1         // pointer for highlighted verbiage lines
      w := y := 0
      v := 0.00
      x := space(10)
      z := space(20)
      team := space(9)
      teams := "Orioles;Red Sox;Blue Jays;Indians;Tigers;Yankees"
      pass1 := pass2 := space(12)
      hilite_info(.t.)
      @ 14, 0 gget v math when hilite_info() message "Enter a math formula"
      @ 15, 0 gget y calculator when hilite_info() picture '#####.##' ;
              message "Right-to-left entry"
      @ 16, 0 gget team list teams when hilite_info() ;
              message "Use spacebar or backspace to toggle team"
      @ 17, 0 gget w step color 'n/bg,+w/r' when hilite_info() ;
              message "Use + and - keys"
      @ 18, 0 gget pass1 message "Enter a password" password "?" ;
              when hilite_info()
      @ 19, 0 gget pass2 message "Enter a password" password ;
              when hilite_info()
      @ 20, 0 gget z proper message "This will be proper-case" ;
              when hilite_info() valid hilite_info( , .t.)
      @ 21, 0 gget x array days picture '@!' noedit message "Please pick a day!"
      setcursor(1)
      read timeout 20 warning 10 exitevent blankscr3(-1)
      setcursor(0)
      waiton("Your passwords were '" + trim(pass1) + "' and '" + ;
              trim(pass2) + "'")
      inkey(2)
      waitoff()
      impbox(50)

   case sel == 11
      any_key := 'Exploding Box'
      setcolor(maincolor)
      cls
      Expbox(00, 00, 9, 36, 5, 20, '+w/rb', any_key)
      inkey(1)
      Expbox(15, 10, 23, 50, 1, 24, '+w/r', any_key+' 2')
      inkey(1)
      Expbox(07, 01, 16, 60, 2, 50, '+gr/n', any_key+' 3')
      inkey(.4)
      Expbox(12, 48, 22, 78, 3, 30, 'n/gr', any_key + ' 4')
      inkey(.4)
      Expbox(01, 30, 04, 78, 1, 75, '+w/g', 'Yet Another '+any_key)
      inkey(2.5)
      impbox(60)
      inkey(.3)
      impbox(60)
      inkey(.3)
      impbox(60)
      inkey(.3)
      impbox(60)
      inkey(.3)
      impbox(60)
      inkey(1)
      *** note the use of the return value and BYEBYEBOX()
      setcolor('n/bg')
      aadd(screens, Popbox(00, 00, 22, 40, 2, 18, .F., 'Pop-up Box 1'))
      inkey(.35)
      setcolor('+gr/n')
      aadd(screens, Dropbox(00, 55, 18, 79, 1, 25, .F., 'Pull-down Box 1', .T.))
      inkey(.35)
      setcolor('n/gr')
      aadd(screens, Popbox(03, 44, 20, 70, 5, 20, .F., 'Pop-up Box 2'))
      inkey(.35)
      setcolor('n/w')
      aadd(screens, Dropbox(04, 38, 13, 60, 4, 25, .F., 'Pull-down Box 2'))
      inkey(.35)
      setcolor('+w/r')
      aadd(screens, Popbox(12, 30, 23, 55, 2, 20, .F., 'Pop-up Box 3', .T.))
      inkey(.35)
      setcolor('+w/b')
      aadd(screens, Popbox(03, 05, 20, 29, 2, 18, .F., 'Another Pop-up'))
      inkey(.35)
      setcolor('n/g')
      aadd(screens, Dropbox(06, 28, 20, 66, 1, 12, .T., 'Another Pull-down Box'))
      inkey(.35)
      setcolor('n/r')
      aadd(screens, Popbox(02, 15, 17, 45, 1, 10, .T., 'Pop-up Box w/ Crossbar', .T.))
      inkey(.35)
      aadd(screens, Shadowbox(09, 20, 14, 50, 2, 'Shadow Box', .T., ;
                              '+w/rb', 'Press a key to make them vanish!'))
      inkey(10)
      FOR xx := 9 TO 1 STEP -1
         ByeByeBox(screens[xx])
         inkey(.12)
      NEXT
      asize(screens, 0)

   case sel == 12
      setcolor(maincolor)
      cls
      setcolor('+w/bg')
      Exbox(9, 07, 15, 71, 1, 5, '', .T., 'Silly Strings')
      Spread('It is a snap to display character strings from the middle out',10,35)
      Spread('as we are demonstrating here. You may also wish to use either',11,35)
      Spread('of the two teletype functions, which continuously scroll your',12,35)
      Spread('message across a specified row.   Perhaps you already saw the',13,35)
      Spread('falling string trick, but in case you missed it,             ',14,35)
      inkey(4)
      FallGuy(14,58,'here it is!!')
      setcolor(maincolor)
      inkey(1)
      tty(20, 'Copyright (C) 1988-90 Greg Lief', 35, 24)
      tty2(maxrow(), 'Press any key to return to the main menu', 0, maincolor)

   case sel == 13
      setcolor('W/N')
      FOR xx := 1 TO 9
         clrscr(xx)
         inkey(.2)
         if xx < 9
            RESTSCREEN(0, 0, maxrow(), maxcol(), mainmenu)
         ENDif
         inkey(.2)
      NEXT
      inkey(1.5)
      mfile := 'DEMO3.SCR'
      PULL_DRAPE('demo.scr')
      inkey(2)
      cls
      inkey(1)
      BLINDOPEN('demo.scr')
      HBLINDSAVE(mfile)
      inkey(1)
      BLINDCLOSE()
      inkey(2)
      HBLINDOPEN(mfile)
      inkey(2)
      HBLINDCLOS()
      inkey(2)
      if file("fadein.scr")
         fadein("fadein.scr")
         inkey(2)
      endif
      if file("fadeout.scr")
         fadeout("fadeout.scr")
         inkey(2)
      endif
      FOR xx := 0 TO maxrow()
         @ xx, 0 say REPLICATE(CHR(xx), maxcol() + 1)
      NEXT
      dumbo := SAVESCREEN(0, 0, maxrow(), maxcol())
      hscrnscrl('demo.scr')
      inkey(.75)
      RESTSCREEN(0, 0, maxrow(), maxcol(), dumbo)
      inkey(.5)
      hscrnscrl('demo.scr', 1)
      inkey(.75)
      RESTSCREEN(0, 0, maxrow(), maxcol(), dumbo)
      inkey(.5)
      vscrnscrl(mfile)
      inkey(.75)
      RESTSCREEN(0, 0, maxrow(), maxcol(), dumbo)
      inkey(.5)
      vscrnscrl(mfile, 1)
      inkey(.75)

   case sel == 14
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), maincolor)
      setcolor('+w/bg')
      Expbox(9, 10, 15, 68, 1, 60, , 'User Feedback')
      Spread('The Grumpfish Library includes many user feedback items.',10,20)
      Spread('There are functions for yes/no prompts, printer status, ',11,20)
      Spread('error messages, wait messages, index status graph, state',12,20)
      Spread("validation, and a sleek ACHOICE() replacement.  We will ",13,20)
      Spread("start out with the index graph function, IndexBar().... ",14,20)
      inkey(5)
      ImpBox(60)
      if ! file('gftemp.dbf') .or. ! file('lookup.dbf')
         waiton("Preparing temporary files... please wait")
         dbcreate("lookup", { { 'code', 'C', 4, 0 } , ;
                              { 'descrip', 'C', 30, 0} } )
         use lookup new
         for xx := 1 to 10
            append blank
            replace code with lookup_[xx, 1], descrip with lookup_[xx, 2]
         next
         dbcreate("gftemp", { { 'lastname', 'C', 30, 0 } } )
         use gftemp new
         for xx := 1 to 1000
            append blank
            replace lastname with chr(gfrand(100) + 65)
         next
         waitoff()
      else
         use lookup new
         use gftemp new
      endif
      indexbar('lastname')
      inkey(2)
      dumbo := Exbox(10, 20, 14, 58, 1, 5, '', .T., 'APICK()')
      Spread('This is an example of APICK(): the',11,20)
      Spread('Grumpfish ACHOICE() replacement...',12,20)
      Spread('Press spacebar to tag/untag files.',13,20)
      inkey(4)
      byebyebox(dumbo)
      thefiles := directory("*.*")
      tags_ := array(len(thefiles))
      aeval(thefiles, ;
            { | a, x | thefiles[x] := a[1], tags_[x] := "PRG" $ a[1] } )
      apick array thefiles tagging tags_
      gfsaveenv(.t., , '+w/b')
      cls
      ? "The following files were tagged:"
      ?
      for xx := 1 to len(tags_)
         if tags_[xx]
            ? thefiles[xx]
         endif
      next
      ?
      ? "Press any key to get on with it...."
      inkey(0)
      gfrestenv()
      if ! yes_no('This is one of the two Grumpfish yes/no prompts',;
                  'Want to see the other one')
         Err_Msg( { "Too bad, you're going to see it anyway" } )
      ENDif
      yes_no2({'Shall we zap the database now?'}, 12, ' OK ', ' Cancel ', .F.)
      if ! yes_no2({'Send the report to:'}, 12, ' Printer ', ' File ')
         waiton("Let's assume that we are printing now")
         inkey(2)
         waitoff()
      ENDif
      inkey(1)
      if isprinter()
         waiton('Please turn off your printer for this demo')
         do while isprinter()
         enddo
         waitoff()
      endif
      printok()
      set device to screen
      Err_msg( { 'This is the error message function!' } )
      setcolor('+w/rb')
      dumbo := Exbox(11, 19, 13, 59, 1, 5, '', .T., 'GETDATE()')
      Spread('Get dates the easy way with GetDate()', 12, 20)
      inkey(2)
      Spread('You selected ' + DTOC(GetDate(DATE(), 0, 56)), 13, 20)
      inkey(3)
      byebyebox(dumbo)
      dumbo := Exbox(10, 15, 14, 64, 1, 5, '', .T., 'Validation')
      Spread('Grumpfish Library offers validation routines for',11,21)
      Spread('state abbreviations and Canadian postal codes...',12,21)
      mstate := space(2)
      @ 13, 21 say "Enter a state abbreviation now:" get mstate valid isstate(@mstate)
      set cursor on
      read
      set cursor off
      inkey(2)
      byebyebox(dumbo)
      setcolor('+W/R')
      dumbo := Exbox(10, 13, 15, 66, 1, 5, '', .T., 'HELPBROW()')
      Spread("Last but not least, Grumpfish has a great picklist", 11, 20)
      Spread("function for data validation.  HELPBROW() makes it", 12, 20)
      Spread("easy to let users add new items to lookup tables..", 13, 20)
      inkey(1)
      mvar := "JUNK"
      @ 14, 15 say "Your code:" get mvar valid helpbrow("lookup", "code", ;
                   "Code", "descrip", "Description", .t., "+w/b", 14, 35)
      setcursor(1)
      readmodal(getlist)
      getlist := {}
      setcursor(0)
      inkey(1)
      byebyebox(dumbo)
      close data
      ferase('lastname' + indexext())

   case sel == 15
      dispbox(0, 0, maxrow(), maxcol(),  replicate(chr(250),9), 'w/b')
      colormod()

   endcase
   restscreen(0, 0, maxrow(), maxcol(), mainmenu)
   colorset(PRIMARY_COLOR)
enddo
return NIL


static function showrecno(browse)
@ maxrow(), 0 say "You can hook into the Grumpbrow() movement like this!  " + ;
                  "Current record # " + ltrim(str(recno())) color "+gr*/b"
return nil


static function dummy(n, browse)
// NOTE: message centered in the browse window
waiton( { "Additional option #" + ltrim(str(n)) },,, ;
          browse:nTop + ((browse:nBottom - browse:nTop) / 2) - 1)
inkey(1)
waitoff()
return nil


static function rollup(mtext)
local xx
scroll(2, 8, 22, 71, 1)
@ 22,08 say padr(mtext, 64)
for xx := 1 to 35
next
return NIL



static function hilite_info(restart, lastline)
static buffer
// if 1st parameter was passed, clear out old BUFFER and do nothing else
if restart != NIL
   buffer := NIL
else

   dispbegin()

   setpos(ptr + 1, 3)
   // restore previous line if there was one saved
   if buffer != NIL
      restscreen(row(), col(), row(), maxcol(), buffer)
   endif

   // 2nd parameter passed only to force highlighting of last line
   // necessary cause you can't use ARRAY clause in conjunction with a WHEN
   if lastline != NIL
      ptr := len(verbiage_)
   else
      ptr := ggetno()
   endif

   // move to new position, save screen, and display text
   setpos(ptr + 1, 3)
   buffer := savescreen(row(), col(), row(), maxcol())
   dispout(padr(verbiage_[ptr], 73), colorset(C_MESSAGEBLINK, .T.))

   dispend()

endif
return .t.

* eof demo5.prg
