/*
    Program: DATEWORD()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper dateword /n/w/a

    Returns verbose date (e.g., 'December 25, 1988')
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function dateword(mdate)
default mdate to date()       // use system date if no date passed
if valtype(mdate) == 'C'       // convert char string to date
   mdate := ctod(mdate)
endif
/* check current date format to see if day should precede month */
return if(substr(set(_SET_DATEFORMAT), 1, 2) == 'dd', ;
          ltrim(str(day(mdate))) + ' ' + gfmonth(mdate), ;
          gfmonth(mdate) + ' ' + ltrim(str(day(mdate))) ) + ', ' + ;
          ltrim(str(year(mdate)))

* end function DateWord()
*--------------------------------------------------------------------*

* eof dateword.prg
