/*
   Program: COLORS.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper colors /n/w/a

   Conversion functions for colors - numeric to character string
                                     and vice versa
   Functions: COLOR_S2N()
            : COLOR_N2S()
*/

// begin global declarations

static foreground := 'N  B  G  BG R  BR GR W  N+ B+ G+ BG+R+ BR+GR+W+ '

// end global declarations


/*
   Color_N2S(): convert color number (0-127) to dBASE color string
*/
function color_n2s(colorno)
local background := 'N B G BGR BRGRW ', blinking
if valtype(colorno) == "C"
   colorno := bin2i(colorno)
endif
blinking := (colorno > 127)
colorno := colorno % 128
return (if(blinking, '*', '') + ;
        trim(substr(foreground, (colorno % 16) * 3 + 1, 3)) + '/' + ;
        trim(substr(background, int(colorno / 16) * 2 + 1, 2)))

* end function Color_N2S()
*--------------------------------------------------------------------*


/*
   Color_S2N(): convert dBASE color string to number
*/
function color_s2n(colorno)
local mslash, mcomma, blinking, mfore, mback

// set start-up color to current color if no parameter passed
colorno := if(colorno == NIL, setcolor(), upper(colorno))

// parse this string to determine foreground and background colors
// first determine how many characters are in the foreground color
// by locating the first slash in the string
mslash := at('/', colorno)

// background color will lie between the slash and the first comma,
mcomma := at(',', colorno)

// but we also must allow for color parameters passed without a comma
if mcomma == 0
   mcomma := len(colorno) + 1
endif

// break out the foreground and background colors
mfore := substr(colorno, 1, mslash - 1)
if ( blinking := '*' $ mfore )
   mfore := strtran(mfore, '*', '')
endif
mback := substr(colorno, mslash + 1, mcomma - mslash - 1)

// take care of screwy magenta, which can be either "RB" or "BR"
if upper(mfore) == "RB"
   mfore := "BR"
endif
if upper(mback) == "RB"
   mback := "BR"
endif

// convert the string to a number
return int(at(mfore, foreground) / 3) +      ;
       int(at(mback, foreground) / 3) * 16 + ;
       if(blinking, 128, 0)

* end function Color_S2N()
*--------------------------------------------------------------------*

* eof colors.prg
