/*
    Program: CLRSCR.PRG
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper clrscr /n/w/a

               Methods #8 and #9 written and provided courtesy of:
                   Laurent Maggiore
                   150 Bd. Poincar
                   06160 Juan-Les_Pins
                   FRANCE

    WILL HANDLE 25/43/50 ROW DISPLAYS (except for methods 7 and 8,
    camera lens and diagonal, which are still 25 x 80 only)
*/

// begin preprocessor directives

#include "grump.ch"
#command CLEARIT(<t>, <l>, <b>, <r>) => scroll(<t>, <l>, <b>, <r>, 0) ;;
                                        for yy := 1 TO ndelay; next
#define MIDPOINT int((maxcol + 1) / 2)

// end preprocessor directives

function clrscr(ntype, ndelay)
local xx, yy, maxrow := maxrow(), maxcol := maxcol(), buffer, mrow, ;
      ndelays := {100, 100, 40, 40, 40, 40, 150, 40, 15}
default ntype to 1
default ndelay to ndelays[ntype]
do case
   case ntype == WINDOWDOWN
      for xx = 0 to maxrow
         CLEARIT(xx, 0, xx, maxcol)
      next
   case ntype == WINDOWUP
      for xx = maxrow to 0 step -1
         CLEARIT(xx, 0, xx, maxcol)
      next
   case ntype == DOORRIGHT
      for xx = 0 to maxcol
         CLEARIT(0, xx, maxrow, xx)
      next
   case ntype == DOORLEFT
      for xx = maxcol to 0 step -1
         CLEARIT(0, xx, maxrow, xx)
      next
   case ntype == CURTAINOPEN
      for xx = MIDPOINT to maxcol
         scroll(00, maxcol-xx, maxrow, maxcol-xx, 0)
         CLEARIT(0, xx, maxrow, xx)
      next
   case ntype == CURTAINSHUT
      for xx = maxcol to MIDPOINT step -1
         scroll(00, maxcol-xx, maxrow, maxcol-xx, 0)
         CLEARIT(0, xx, maxrow, xx)
      next
   case ntype == CAMERALENS     // still set up for 25 x 80 mode
      mrow := 0
      for xx = 0 to 33 step 3
          scroll(mrow, xx, mrow, maxcol - xx, 0)
          scroll(maxrow - mrow, xx, maxrow - mrow, maxcol - xx, 0)
          scroll(mrow, xx, maxrow - mrow, xx + 3, 0)
          CLEARIT(mrow, 76 - xx, maxrow - mrow, maxcol - xx)
          mrow++
      next
      scroll(mrow, 37, mrow, 42, 0)
   case ntype == DIAGONAL        // still set up for 25 x 80 mode
      for xx = 0 to maxcol
         scroll(int(xx/3.2), xx, maxrow, xx, 0)
         scroll(0, maxcol - xx, maxrow - int(xx/3.2), maxcol - xx, 0)
         for yy = 1 to ndelay
         next
      next
   otherwise                    // HALVES
      for xx = 0 to maxrow
         buffer := savescreen(xx, 0, maxrow - 1, MIDPOINT - 1)
         scroll(xx, 0, xx, MIDPOINT - 1, 0)
         if xx < maxrow
           restscreen(xx+1, 0, maxrow, MIDPOINT - 1, buffer)
         endif
         buffer := savescreen(1, MIDPOINT, maxrow-xx, maxcol)
         scroll(maxrow-xx, MIDPOINT, maxrow-xx, maxcol, 0)
         if xx < maxrow
           restscreen(0, MIDPOINT, maxrow - 1 - xx, maxcol, buffer)
         endif
         for yy = 1 to ndelay
         next
      next
endcase
return NIL

* end function ClrScr()
*--------------------------------------------------------------------*

* eof clrscr.prg
