/*
   Function: CHECKAPPTS()
   System:   GRUMPFISH LIBRARY
   Author:   Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper chk_appt /n/w/a
   Calls: POPDATE.PRG
   Uses: APPT.DBF
   Indexes: APPT.NTX
*/

#include "inkey.ch"
#include "grump.ch"

function checkappts(cDir, cUser, nDays)
local nWorkarea := select()
local cOldscrn
local dDate := date()
local cFile
local nKey
local nMidrow
local nMidcol
default cUser to ''
default nDays to 0
cFile := if(cDir = NIL, '', cDir + if(right(cDir, 1) <> '\','\','')) + 'appt'
if file(cFile + '.dbf') .and. file(cFile + '.dbt') .and. ;
                              file(cFile + 'date' + indexext())
   use (cFile) index (cFile + 'date') new
   if dbseek( dtos(dDate) + cUser ) .and. ! deleted()
      GFSaveEnv(, 0)
      ColorSet(C_MESSAGE)
      nMidrow := int( maxrow() / 2)
      nMidcol := int( (maxcol() + 1) / 2)
      cOldscrn := shadowbox(nMidrow - 2, nMidcol - 16, nMidrow + 2, ;
                            nMidcol + 15, 2)
      tone(MUSIC_WAITON[1], 1)
      tone(MUSIC_WAITON[2], 1)
      @ nMidrow,     nMidcol - 14 say 'Press F2 to check calendar,'
      @ nMidrow + 1, nMidcol - 14 say 'or any other key to proceed'
      ColorSet(C_MESSAGEBLINK)
      if nDays == 0
         @ nMidrow - 1, nMidcol - 14 say 'You have appointments today!'
      else
         @ nMidrow - 1, nMidcol - 14 say 'Appointments for ' + dtoc(dDate) + '!'
      endif
      nKey := ginkey(0)
      byebyebox(cOldscrn)
      use
      if nKey == K_F2
         popdate()
      endif
      GFRestEnv()
   else
      use
   endif
endif
select(nWorkarea)
return NIL

* eof chk_appt.prg
