/*
    Program: CALC_PIC()
    System:  GRUMPFISH LIBRARY
    Author:  Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper calcpic /n/w/a
    Enables calculator-style numeric data entry
*/

// begin preprocessor directives

#include "inkey.ch"
#include "grump.ch"

// end preprocessor directives

function calc_pic(number, pitcher)
local decplace := 0, key := 0, tnum, maxdecimal, mrow := row(), mcol := col(), ;
      commas := 0, xx
GFSaveEnv()
setcolor(substr(setcolor(), at(',', setcolor())+1))   // sneaky sneaky

// determine maximum # of decimals based on location of decimal point
maxdecimal := if(at('.', pitcher) > 0, len(pitcher) - at('.', pitcher), 0)

/* determine if there are commas in the picture
   clause -- if so, we must account for them
*/
if ',' $ pitcher
   // loop through picture clause and tally up # of commas
   for xx = 1 to len(pitcher)
      if substr(pitcher, xx, 1) = ','
         commas++
      endif
   next
endif

/*
  begin main loop

  We simulate an actual read by allowing the following active keys:
  enter,  esc,  ctrl-w,  uparrow, downarrow, pgup, and pgdn

  If you want to limit escape from this routine, it is a simple
  matter to remove the desired key values from the next statement
*/

do while key != K_ENTER .and. key != K_ESC .and. key != K_CTRL_W .and. ;
         key != K_UP .and. key != K_DOWN  .and. key != K_PGUP .and. ;
         key != K_PGDN
   @ mrow, mcol say number picture pitcher
   key := ginkey(0)
   do case
      // user pressed a numeric key
      case key > 47 .and. key < 58
         tnum := val(chr(key))             // determine numeric value
         do case
            case number = 0 .and. decplace = 0
               number := tnum
            case number != 0 .and. decplace=0 .and. ;
                          number < 10 ^ (len(pitcher) - maxdecimal - 2 - commas)
               number = number * 10 + tnum
            case decplace > 0 .and. decplace <= maxdecimal     // real number
               number += (tnum / (10 ^ decplace))
               decplace++
         endcase

      // user pressed hyphen to toggle sign of number
      case key == 45
         number *= -1

      case key == K_BS .and. number != 0
         do case
            // if number is still an integer, kill least significant digit
            case decplace = 0
               number := int(number / 10)
            *** if we are at one decimal place, change number to integer
            case decplace = 2
               decplace := 0
               number := int(number)
            otherwise
               decplace--
               number := ltrim(str(number, 16, decplace))
               number := val(substr(number, 1, len(number) - 1))
         endcase

      // user pressed period to set the decimal point
      case key == 46 .and. decplace == 0 .and. maxdecimal > 0
         decplace := 1

   endcase
enddo

// must stuff last keypress into buffer so it will be acted upon properly
keyboard chr(key)

GFRestEnv()
return pitcher

* end function Calc_Pic()
*--------------------------------------------------------------------*

* eof calc_pic.prg
