/*
   Program: BOX_TITLE()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper boxtitle /n/w/a

   Called by: EXBOX()
              POPBOX()
              DROPBOX()
              SHADOWBOX()

   NOT FOR USE AS A STAND-ALONE FUNCTION!!!

   Draws box title with frame
*/

// begin preprocessor directives

#include "grump.ch"

// end preprocessor directives

function box_title(ntop, nleft, nright, ctitle, cboxstring, lcrossbar, ccolor)
local nwidth := nright - nleft + 1
local nmidpoint
local tleft
// truncate header to fit within box width
if len(ctitle) > nwidth - 6
   ctitle := rtrim( substr(ctitle, 1, nwidth - 6) )
endif
tleft := nleft + (int(nwidth - len(ctitle)) / 2)
default lcrossbar to .f.
if lcrossbar
   @ ntop + 1, tleft ssay ctitle color ccolor
   @ ntop + 2, nleft ssay substr(cboxstring, 12, 1) + ;
               replicate(substr(cboxstring, 2, 1), (nwidth - 2)) + ;
               substr(cboxstring, 13, 1) color ccolor
else
   @ ntop, tleft - 2 ssay ;
           substr(cboxstring, 10, 1) + ' ' + ctitle + ' ' + ;
           substr(cboxstring, 11, 1) color ccolor
endif
return nil

* end function box_title()
*--------------------------------------------------------------------*

* eof boxtitle.prg
