/*
   Program: BOXGET()
   System:  GRUMPFISH LIBRARY
   Author:  Greg Lief
   Copyright (c) 1988-91, Greg Lief
   Compile instructions: clipper boxget /n/w/a
   Generic GET function
*/

// begin preprocessor directives

#include "box.ch"
#include "grump.ch"
#include "setcurs.ch"
#include "inkey.ch"

// end preprocessor directives

// begin global declarations

#define DELIMITERPAD  if(set(_SET_DELIMITERS), 2, 0)
#define TOP     nrow
#define LEFT    ncol
#define BOTTOM  nrow + 2
#define RIGHT   ncol + len(cprompt) + 4 + getlength + DELIMITERPAD

// end global declarations

function boxget(cprompt, nrow, ncol, oget, bvalid, cboxcolor, ;
                norestore, restall, double, ctitle)
static boxstack_ := {}       // to store screen shots
local x
local getlength
local oldscore
local oldscrn
local oldins

// set insert key to toggle both insert mode & cursor
oldins := setkey( K_INS, {|| setcursor( ;
         if(readinsert(! readInsert()), SC_NORMAL, SC_SPECIAL1))} )
oldscore := set(_SET_SCOREBOARD, .f.)
GFSaveEnv(, , cboxcolor)   // switch to box color

/*
  Determine length of GET variable by verifying the length of the GET
  buffer.  This is necessary not only in the event that no PICTURE
  clause was used, but also because we cannot always trust the PICTURE
  clause (e.g., "@!" and "@R"). Note that the GET must be activated with
  the setFocus() method, because the g:buffer instance variable only exists
  when the GET is active.  Also notice that although the GET is activated,
  it will not appear on the screen.  Why is this??  Look carefully at the
  BOXGET user-defined command in GRUMP.CH -- there lies the answer.
*/
oget:setFocus()

// determine length of GET buffer but check first for @S Picture
// special thanks to Kevin Farley for his comments in this regard
// note: this assumes that the scroll length will be two digits
if oget:picture != NIL .and. (x := at("S", oget:picture) ) > 0
   getlength := val(substr(oget:picture, x + 1, 2))
else
   getlength := len(oget:buffer)
endif
oget:killFocus()

// truncate long prompts to fit on screen
cprompt := substr(cprompt, 1, maxcol() - 4 - DELIMITERPAD - getlength)

// establish defaults for box title, row, and column positions
default ctitle to ''
default nrow to int( maxrow() / 2) - 1
default ncol to int( maxcol() - 3 - len(cprompt) - DELIMITERPAD - ;
                     getlength ) / 2

oldscrn := shadowbox(TOP, LEFT, BOTTOM, RIGHT, if(double, 1, 2), ctitle)

// if NORESTORE was specified, add the affected portion of screen
// to box stack so we can restore it later
if norestore
   aadd(boxstack_, oldscrn )
endif
setpos(TOP + 1, LEFT + 2)
oget:postBlock := bvalid       // set up VALID clause manually
dispout( cprompt )
oget:row := row()              // set up GET row manually

// if delimiters are set ON, we must display them manually
// because GETNEW() does not respect the rascally things!
if set(_SET_DELIMITERS)
   oget:col := col() + 2
   dispout(' ' + left(set(_SET_DELIMCHARS), 1) + ;
           space(getlength) + right(set(_SET_DELIMCHARS), 1))
else
   oget:col := col() + 1
endif

// initial cursor setting based on current mode
setcursor( if(readInsert(), SC_SPECIAL1, SC_NORMAL) )

readmodal( { oget } )

// restore all screens if RESTOREALL was specified
if restall
   ByeByeBox(oldscrn)
   if ! empty(boxstack_)
      for x := len(boxstack_) to 1 step -1
         restscreen(boxstack_[x, 1], boxstack_[x, 2], boxstack_[x, 3], ;
                    boxstack_[x, 4], boxstack_[x, 5])
      next
      asize(boxstack_, 0)
   endif
elseif ! norestore
   ByeByeBox(oldscrn)
endif

// restore all other environmental aspects
GFRestEnv()
setkey(K_INS, oldins)                // reset INSERT key
set(_SET_SCOREBOARD, oldscore)       // argh... does anybody use this?
return nil
