/*
   Program: BLINDS.PRG
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x version
   Compile instructions: clipper blinds /n/w/a
   Special thanks to Cecilia Smith for her additions!
   Procs & Fncts: BLINDOPEN()
                : BLINDCLOSE()
*/

// begin preprocessor directives

#include "fileio.ch"
#include "grump.ch"

// end preprocessor directives

/*
   Function: BLINDOPEN()
   Purpose:  Draw title screen using blinds effect
   NOTE:     Title screen must be pre-saved using SAVE_DRAPE()
   Syntax:   Blindopen(<name of screen file>, [<delay>])
             Default delay is 5
   WILL HANDLE 25/43/50 ROW DISPLAYS
*/
function blindopen(cfile, nDelay)
local nhandle
local nMaxrow := maxrow()
local nMaxcol := maxcol()
local nDosrow := nMaxrow + 1
local nDoscol := nMaxcol + 1
local screen_[nDoscol]
local xx
local yy
local nbufferlen := nDosrow * 2
local buffer
local yyHi := int( nMaxcol / 10 )
local nBytes

default nDelay to 5
if file(cfile)
   nhandle := fopen(cfile, FO_READ)
   nBytes := nDosrow * nDoscol * 2

   // verify that this file was saved in the same mode that we are in
   // because if it wasn't, all hell will break loose further down
   if ( xx := fseek(nhandle, 0, FS_END) ) == nBytes .or. ( xx == nBytes + 4 )
      fseek(nhandle, xx - nBytes, FS_SET) // reset to start
      for xx := 1 to nDoscol
         buffer := space(nbufferlen)
         fread(nhandle, @buffer, nbufferlen)
         screen_[xx] := buffer
      next
      for xx := 0 to 9
         for yy := 0 to yyHi
            if yy * 10 + xx <= nMaxcol
               restscreen(0, yy * 10 + xx, nMaxrow, yy * 10 + xx, ;
                          screen_[yy * 10 + xx + 1])
            endif
         next
         for yy := 1 to nDelay
         next
      next
   endif
   fclose(nhandle)
endif
return NIL

* end function BlindOpen()
*--------------------------------------------------------------------*


/*
   Function: BLINDCLOSE()
   Purpose:  Clear screen using blinds effect
   Syntax:   BlindClose([<nDelay>])
             Default nDelay is 10
*/
function blindclose(nDelay)
local xx
local yy
local nMaxrow := maxrow()
local nMaxcol := maxcol()
local yyHi := int(nMaxcol / 10)
default nDelay to 10
for xx := 9 to 0 step -1
   for yy := yyHi to 0 step -1
      if yy * 10 + xx <= nMaxcol
         scroll(0, yy * 10 + xx, nMaxrow, yy * 10 + xx, 0)
      endif
   next
   for yy := 1 to nDelay
   next
next
return NIL

* end function BlindClose()
*--------------------------------------------------------------------*

* eof blinds.prg
