/*
    Program: BLANKSCR4()
    System:  GRUMPFISH LIBRARY
    Author:  Greg Lief
    Copyright (c) 1988-92, Greg Lief
    Clipper 5.01 Version
    Compile instructions: clipper blank5 /n/w/a

    Yet another screen-blanker... this time, the sliding blocks.
    Note: Compatible with 25- or 50-line video mode

    Calls: GFRAND()      (function in RAND.PRG)
*/

#include "box.ch"
#include "grump.ch"
#include "inkey.ch"

static cTemp

#define TOP       1
#define LEFT      2
#define BOTTOM    3
#define RIGHT     4
#define CONTENTS  5

#define UP        1
#define DOWN      3

#define DELAY    400

function blankscr4(delay, cPassword)
local oldrow := row()
local oldcol := col()
local w, x, y
local z := 0
local num_blocks := if(maxrow() < 25, 40, 80)
local blocks_ := array(num_blocks)
local key := 0
local direction
local lastdirection
local mstart := seconds()
local oldscrn
local bCondition
do while nextkey() = 0 .and. seconds() - mstart < delay
enddo
if nextkey() == 0        // i.e., do while loop timed out with no keypress
   GFSaveEnv(.t., 0)
   w := if(maxrow() < 25, 20, 45)
   for x := 0 to w step 5
      for y := 0 to 70 step 10
         blocks_[++z] := { x, y, x + 4, y + 9, savescreen(x, y, x + 4, y + 9) }
      next
   next

   // determine first block to be cleared
   y := x := gfrand(num_blocks) + 1
   scroll(blocks_[x][TOP], blocks_[x][LEFT], blocks_[x][BOTTOM], ;
          blocks_[x][RIGHT])
   if cPassword == NIL
      bCondition := { || inkey() == 0 }
   else
      cTemp      := ''
      cPassword  := upper(cPassword)
      bCondition := { || password(cPassword) }
   endif
   do while eval(bCondition)
      do while y == x
         direction := gfrand(4) + 1
         do case
            case direction == UP .and. lastdirection != DOWN .and. x > 8
               y -= 8
               for z := 1 to 5
                  dispbegin()
                  restscreen(blocks_[y][TOP] + z, blocks_[y][LEFT], ;
                             blocks_[y][BOTTOM] + z, blocks_[y][RIGHT], ;
                             blocks_[y][CONTENTS])
                  scroll(blocks_[y][TOP] + z - 1, blocks_[y][LEFT], ;
                         blocks_[y][TOP] + z - 1, blocks_[y][RIGHT])
                  dispend()
                  w := 1
                  do while ++w < DELAY
                  enddo
               next
            case direction == DOWN .and. lastdirection != UP ;
                                   .and. x < num_blocks - 7
               y += 8
               for z := 1 to 5
                  dispbegin()
                  restscreen(blocks_[y][TOP] - z, blocks_[y][LEFT], ;
                             blocks_[y][BOTTOM] - z, blocks_[y][RIGHT], ;
                             blocks_[y][CONTENTS])
                  scroll(blocks_[y][BOTTOM] - z + 1, blocks_[y][LEFT], ;
                         blocks_[y][BOTTOM] - z + 1, blocks_[y][RIGHT])
                  dispend()
                  w := 1
                  do while ++w < DELAY
                  enddo
               next
            case direction == LEFT .and. lastdirection != RIGHT .and. x % 8 != 1
               y--
               for z := 2 to 10 step 2
                  dispbegin()
                  restscreen(blocks_[y][TOP], blocks_[y][LEFT] + z, ;
                             blocks_[y][BOTTOM], blocks_[y][RIGHT] + z, ;
                             blocks_[y][CONTENTS])
                  scroll(blocks_[y][TOP], blocks_[y][LEFT] + z - 2, ;
                         blocks_[y][BOTTOM], blocks_[y][LEFT] + z - 1)
                  dispend()
                  w := 1
                  do while ++w < DELAY
                  enddo
               next
            case direction == RIGHT .and. lastdirection != LEFT .and. x % 8 != 0
               y++
               for z := 2 to 10 step 2
                  dispbegin()
                  restscreen(blocks_[y][TOP], blocks_[y][LEFT] - z, ;
                             blocks_[y][BOTTOM], blocks_[y][RIGHT] - z, ;
                             blocks_[y][CONTENTS])
                  scroll(blocks_[y][TOP], blocks_[y][RIGHT] - z + 1, ;
                         blocks_[y][BOTTOM], blocks_[y][RIGHT] - z + 2)
                  dispend()
                  w := 1
                  do while ++w < DELAY
                  enddo
               next
         endcase
      enddo
      blocks_[x][CONTENTS] := blocks_[y][CONTENTS]
      x := y
      lastdirection := direction
   enddo
   GFRestEnv()
endif
return nil


static function password(cPassword)
local key := inkey()
local ret_val := .t.
if key > 0
   do case
      case key <> K_ENTER
         cTemp += upper(chr(key))
      case key == K_ENTER
         if cTemp == cPassword
            ret_val := .f.   // forces exit from screen blank loop above
         else
            cTemp := ''
            tone(MUSIC_RASPBERRY,1)
         endif
      case key == K_BS .and. ! empty(cTemp)
         cTemp := left(cTemp, len(cTemp) - 1)
   endcase
endif
return ret_val


* eof blank5.prg
