/*
    Program: BLANKSCR2()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x Version
    Compile instructions: clipper blank3 /n/w/a

    A whimsical screen-saver (a dancing smiley face)

    Calls: GFRAND()      (function in RAND.PRG)
*/

#include "setcurs.ch"
#include "grump.ch"
#include "inkey.ch"

static cTemp

function blankscr2(delay, cPassword)
local nStart := seconds()
local nTop
local nBottom
local buffer
local bCondition
do while nextkey() == 0 .and. seconds() - nStart < delay
enddo
if nextkey() == 0     // timed out with no keypress
   GFSaveEnv(.t., 0, '+w/n')
   scroll()
   nTop := gfrand(maxrow() + 1)
   nBottom := gfrand(maxcol() + 1)
   nStart := seconds()
   @ nTop, nBottom say chr(2)
   if cPassword == NIL
      bCondition := { || inkey() == 0 }
   else
      cTemp      := ''
      cPassword  := upper(cPassword)
      bCondition := { || password(cPassword) }
   endif
   do while eval(bCondition)
      if seconds() - nStart > 2.5
         scroll(nTop, nBottom, nTop, nBottom, 0)
         nTop := gfrand(maxrow() + 1)
         nBottom := gfrand(maxcol() + 1)
         @ nTop, nBottom say chr(2)
         nStart := seconds()
      endif
   enddo
   GFRestEnv()
endif
return NIL


static function password(cPassword)
local key := inkey()
local ret_val := .t.
if key > 0
   do case
      case key <> K_ENTER
         cTemp += upper(chr(key))
      case key == K_ENTER
         if cTemp == cPassword
            ret_val := .f.   // forces exit from screen blank loop above
         else
            cTemp := ''
            tone(MUSIC_RASPBERRY,1)
         endif
      case key == K_BS .and. ! empty(cTemp)
         cTemp := left(cTemp, len(cTemp) - 1)
   endcase
endif
return ret_val


* eof blank3.prg
