/*
   Program: BLANKSCRN()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1989, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper blank2 /n/w/a

   Blanks the screen to prevent monitor wear and tear during inactivity
   Designed for use with GET-IT's N_NOKEY() function

   GET-IT is a trademark of Communications Horizons.
*/

// begin preprocessor directives

#include "setcurs.ch"
#include "grump.ch"

// end preprocessor directives

function blankscrn
local mtop, mbott, buffer, mstart
GFSaveEnv(.t., 0, 'w/n')
scroll()
ColorSet(C_MESSAGE)
mbott := (mtop := int(maxrow() / 2) - 2) + 3
SINGLEBOX(mtop, 25, mbott, 53)
@ mtop + 1, 27 say 'The screen has been saved'
@ mtop + 2, 27 say 'Push spacebar to continue'
setcolor('w/n')
buffer := savescreen(mtop, 25, mbott, 53)
mstart = seconds()
do while inkey() = 0
   if seconds()-mstart > 10
      scroll(mtop, 25, mbott, 53, 0)
      mtop := if(mtop > maxrow() - 4, 0, mtop + 1)
      mbott := if(mbott = maxrow(), 3, mbott + 1)
      restscreen(mtop, 25, mbott, 53, buffer)
      mstart := seconds()
   endif
enddo
GFRestEnv()
return NIL

* eof blank2.prg
