/*
    Program: BLANKSCR()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.0 Version
    Compile instructions: clipper blank1 /n/w/a
    Blanks screen to prevent monitor wear and tear during inactivity
*/

// begin preprocessor directives

#include "setcurs.ch"
#include "grump.ch"

// end preprocessor directives

function blankscr(delay)
local mstart := seconds(), mtop, mbott, buffer
do while nextkey() == 0 .and. seconds() - mstart < delay
enddo
if nextkey() == 0     && i.e., the do while loop timed out with no keypress
   GFSaveEnv(.t., 0, 'w/n')
   scroll()
   ColorSet(C_MESSAGE)
   mbott := (mtop := int(maxrow() / 2) - 2) + 3
   SINGLEBOX(mtop, 25, mbott, 53)
   @ mtop + 1, 27 ssay 'The screen has been saved'
   @ mtop + 2, 27 ssay 'Push spacebar to continue'
   setcolor('w/n')
   buffer := savescreen(mtop, 25, mbott, 53)
   mstart := seconds()
   do while inkey() == 0
      if seconds() - mstart > 10
         scroll(mtop, 25, mbott, 53, 0)
         mtop := if(mtop > maxrow() - 4, 0, mtop + 1)
         mbott := if(mbott == maxrow(), 3, mbott + 1)
         restscreen(mtop, 25, mbott, 53, buffer)
         mstart := seconds()
      endif
   enddo
   GFRestEnv()
endif
return NIL

* eof blank1.prg
