/*
    Program: Amt2Chr()
    System: GRUMPFISH LIBRARY
    Author: Greg Lief
    Copyright (c) 1988-90, Greg Lief
    Clipper 5.x version
    Compile instructions: clipper $amt2chr /n/w/a

    Convert numeric to character-string (dollar format), great for
    writing checks (make 'em payable to Grumpfish, Inc.)
*/
function Amt2Chr(namount)
local cstring := '', temp, xx
for xx := 6 to 0 step -3
   if namount >= 10 ^ xx
      temp := int(namount / 10 ^ xx)
      cstring += convert_it(temp) + if(xx = 6, ' million', ;
                if(xx = 3, ' thousand', ''))
      namount -= temp * 10 ^ xx
      if namount > 0
         cstring += ' '
      endif
   endif
next
if namount != int(namount)
   cstring += 'and ' + str((namount - int(namount)) * 100, 2) + '/100ths'
else
   cstring += ' exactly'
endif
return cstring

* end function Amt2Chr()
*--------------------------------------------------------------------*


/*
   Static Function: CONVERT_IT()
*/
static function convert_it(namount)
static words := {'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', ;
      'Eight', 'Nine', 'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', ;
      'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen', 'Twenty', ;
      'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'}
local cstring := '', temp
if namount > 99
   temp := int(namount / 100)
   cstring += words[temp] + ' hundred'
   namount -= temp * 100
   if namount > 0
      cstring += ' '
   endif
endif
do case
   case namount > 0 .and. namount < 20
      cstring += words[namount]
   case namount > 19
      temp := int(namount / 10)
      cstring += words[temp + 18]
      namount -= temp * 10
      if namount != 0
         cstring += '-' + words[namount]
      endif
endcase
return cstring

* end static function Convert_It()
*--------------------------------------------------------------------*

* eof amt2chr.prg
