/*
   Program: ADD_REC()
   System: GRUMPFISH LIBRARY
   Author: Greg Lief
   Copyright (c) 1988-90, Greg Lief
   Clipper 5.x Version
   Compile instructions: clipper addrec /n/w/a
   Attempts to APPEND BLANK in multi-user environment
*/

// begin preprocessor directives

#include "grump.ch"
#include "inkey.ch"

// end preprocessor directives


function Add_Rec(waittime)
// establish condition to wait for record to be appended
// if user passed parameter, use that as number of seconds to wait;
// otherwise, wait until the user presses the Esc key
local start, waitcond := if(waittime == NIL, { || lastkey() != K_ESC}, ;
      { || seconds()-start < waittime})
if len(alias()) = 0    && no database in use
   return .f.
endif
append blank
if ! neterr()
   return .t.
else
   start := seconds()
   do while eval(waitcond)
      append blank
      if ! neterr()
         return .t.
      endif
   enddo
   Err_Msg( { NETERR_MSG } )
endif
return .f.

* end function Add_Rec()
*--------------------------------------------------------------------*

* eof addrec.prg
