; ****************************************************************************
; This mini-demonstration lets you add customer information into the Cust
; table under the supervision of DoWait.  Before attempting to play this
; script make sure you've followed the directions (listed under "Using DoWait"
; in the Data Entry Toolkit chapter of the PAL User's Guide) for making the
; DoWait Procedure Assignment (DPA) script MINIPROC.SC.  We've actually made
; and included a copy of it for you--it's named MINIDPA.SC.
; ****************************************************************************

; EditCustInfo is the main procedure of this mini-demonstration.  It loads
; and executes the Toolkit procedures required to run the demo.
;
Proc EditCustInfo()

   ;Read Toolkit procedures necessary for this mini-demonstration
   Readlib SDir()+"Toolkit" InitWait,     ;Loads DoWait
                            SetKeycodes,  ;Defines mnemonic keycodes
                            EditMenu      ;Presents a simple edit menu

   SetKeycodes()      ;SetKeycodes defines variables which make it easier for
                      ; us to remember ASCII and IBM Extended keycode values
                      ; (we'll be using a couple of them below).
   InitWait(1,"1","Cust")  ;InitWait loads DoWait and its supplementary
                           ; procedures.  This particular set of arguments
                           ; instructs DoWait that:
                           ; a. the highest image number of a table we'll be
                           ;    using with DoWait is 1 (the first argument).
                           ; b. the image number of the table we'll be using
                           ;    (Cust) is "1" (the second argument).
                           ; c. the table linked to the image number (second
                           ;    argument) is "Cust" (the third argument).

   Release Procs InitWait,   ;Release procs we no longer need
                 SetKeycodes

   Play "MiniProc"     ;Define DoWait procedure assignments and key classes
                       ;  (defined in the DPA procedure saved in MiniProc by
                       ;   SetUpDoWait).
;  Play "MiniDPA"      ;MiniDPA is a copy of MiniProc we've already made for
                       ; you.

   Edit "Cust"         ;View Cust, the table we'll be using with DoWait
   End
   Down                ;Open up a new record
   PickForm "1"        ;View the customer information form

                       ;Customize prompt lines
   Prompt "Entering customer information.",
          "Press [F2] to add customer to master list or [F10]/Cancel to cancel."

   DoWait("Welcome to DoWait")  ;Invoke DoWait, displaying an entry message

   Prompt              ;Restore the Paradox system prompt line

   If Retval = TKDo_It!   ;If user pressed Do-It! to exit DoWait, save
      Then Do_It!         ; changes.  Otherwise, cancel all changes.
      Else CancelEdit
   Endif

Endproc

; DoWait calls LeaveName when a user presses a "regular" key within the
; Last Name and First Name fields of the Cust table.  LeaveName will
; automatically move the cursor to the next field if a user presses the
; spacebar in either of these fields.
;
Proc LeaveName()


   If TKChar = TKSpaceBar      ;Was the pending key (TKChar) the spacebar?
      Then TKChar = TKRight    ;If so, change its value, making Paradox
   Endif                       ; act upon right arrow (TKRight) instead.

  ;TKSpaceBar and TKRight are variables defined by the Toolkit's SetKeycodes
  ; procedure above.

Endproc

; DoWait calls SetDiscount when a user leaves the Zip Code field of
; the Cust table.  If the Zip Code is greater than 90000 (the
; customer is on the west coast), then SetDiscount automatically enters
; a value of 15 into the Discount % field.  SetDiscount is an example of a
; field departure procedure--one called by DoWait when a user moves out
; of a field.

Proc SetDiscount()
   If IsBlank([Discount %])                     ;Only fill Discount % if not
      Then If [] > "90000"                      ; already given a value.
              Then [Discount %] = 15
              Else [Discount %] =  0
           Endif
   Endif

Endproc

Reset              ;Clear the workspace
EditCustInfo()     ;Initialize editing session
Release Vars All   ;Release variables
