; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  MJP 2/29/88, DCY 12/16/88
; ****************************************************************************
; When applied to a lookup table, LookupSelect allows you to determine the key
; a user presses to end the lookup help interaction.  Although it is possible
; to enter into lookup help from within a PAL WAIT command or DoWait, it is
; unfortunately not possible to determine the key a user presses to exit from
; lookup help.  Thus if you want to determine the key a user presses to
; exit lookup help, you'll need to call either this procedure or LookupWait.
; DoWait does not do any special processing within a lookup help interaction.
;
; LookupSelect does not allow a user to make changes to images.  It returns
; the keycode value of the key causing exit from the wait, either [F2] Do-It!
; or [Esc] ([Ctrl][Break] acts like [Esc]).  See also LookupWait, however.
; As with the PAL WAIT comand, LookupSelect exits BEFORE passing the exit key
; to Paradox.
;
; IMPORTANT:  LookupSelect uses the ImageRights ReadOnly command to prevent a
;             user from making changes to the current image.  On exit, it
;             removes all image restrictions.  Thus, if you have previously
;             applied an ImageRights command to the image you will need to
;             do so again after invoking LookupSelect.
;
Proc LookupSelect()
   Echo Normal             ;Display the table to the user
   ImageRights ReadOnly    ;Prevent user from making changes to image
   While True
      Retval = GetChar()
      If MenuChoice() = "Error" and  ;We could be in HELP, HELP INDEX, or ZOOM
           (Retval = -60 or Retval = 27 or Retval = 0)
         Then Quitloop
         Else
      Endif
      If (Retval < -60 and Retval > -71)  ;Disable keys which would allow a
           or Retval = -110 or Retval = -111 or Retval = -100 ; user to leave
         Then Beep                                            ; or clear image
         Else Keypress Retval
      Endif
   Endwhile
   Echo Off
   SyncCursor
   If Retval = 0
       Then Retval = 27            ;[Ctrl][Break] functions as an [Esc]
   Endif                          ; from lookup help.
   ImageRights            ;Restore image status of table
   Return Retval
Endproc
