; Copyright (c) 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.: RFG 12/16/88, DCY 12/18/88
; ****************************************************************************
;  NAME: ToggleCommentary
; EVENT: N/A
; NOTES: ToggleCommentary toggles the state of commentary mode.
; ****************************************************************************
Proc ToggleCommentary()

   If Commentary                  ;Is commentary already on?
      Then Commentary = False     ;  Yes-turn it off
           TKMessage = "Commentary is now turned off"
      Else Commentary = True      ;  No-turn it on
           TKMessage = "Commentary is now turned on"
   Endif
   TKAccept = False ;Don't want Paradox to act upon [Alt][C] key (beep)

Endproc
Writelib DemoLib ToggleCommentary
Release Procs ToggleCommentary

; ****************************************************************************
;  NAME: InactivityProc
; EVENT: Keyboard Inactivity
; FIELD: N/A
; TABLE: Invoice, Cust, Orders
; NOTES: InactivityProc is assigned as the keyboard inactivity procedure for
;        the Invoice, Cust, and Orders tables.  If commentary mode is on,
;        InactivityProc will display a help box after 2 seconds of keyboard
;        inactivity.  Because we're using one inactivity procedure for all
;        three tables we need to first check the current image as well as the
;        current field.
; ****************************************************************************
Proc InactivityProc()

   ;Only show help box for a field if commentary mode is on and if three
   ; or more seconds has elapsed since a keypress.  Note that since we're
   ; requiring TKSeconds < 4 to display a help box, we'll only display a
   ; help box once until a user presses a key.
   If Commentary and TKSeconds < 4 and Mod(TKSeconds,3) = 0
      Then Echo Off
           Style Attribute SysColor(9)
           Switch
              Case ImageNo() = 1 :   ;Cust table
                 Switch  ;TKFieldNum is the column number of the current field
                    Case not NewCust:
                       ViewCustBox()      ;Display-only Cust record
                    Case TKFieldNum = 7 :  
                       CustStateBox()    ;State field
                    Case TKFieldNum = 9 :
                       CustPhoneBox()    ;Phone field
                    Otherwise :
                       EditCustBox()      ;Modifiable Cust record
                 Endswitch
              Case ImageNo() = 2 :   ;Invoice table
                 Switch
                    Case TKFieldNum = 4 :
                       CustNoBox()       ;Customer No.
                    Case TKFieldNum = 7 :
                       MethPaymntBox()   ;Method of Payment
                    Case TKFieldNum = 8 :
                       CardNumHelp()     ;Credit card number
                    Case TKFieldNum = 9 :
                       ExpirDateBox()    ;Expiration date
                    Case TKFieldNum = 10 :
                       ShipViaBox()      ;Ship Via
                 Endswitch
              Otherwise :            ;Orders table
                 OrdersBox()
           Endswitch
           SetMargin Off
           SyncCursor
           Style
   Endif

Endproc
Writelib DemoLib InactivityProc
Release Procs InactivityProc

; ****************************************************************************
; The remaining procedures simply display commentary text when activated.
; ****************************************************************************

Proc CustStateBox()

   @ 14, 4
   SetMargin 4
   Text
ͻ
  A Paradox picture validity check forces the State code to two        
  upper-case letters.  A lookup table could be used to test for valid  
  input, although that has not been done here.                         
                                                                       
  If you enter "CA" as the state code, 7.5% tax will be added to the   
  order; otherwise, no tax will be added.                              
    
  Enter a state code.  You will automatically move to the next field.  
ͼ
   Endtext

Endproc
Writelib DemoLib CustStateBox
Release Procs CustStateBox

Proc CustPhoneBox()

   @ 14, 4
   SetMargin 4
   Text
ͻ
  You may enter a Telephone number with or without an area code.  If   
  you supply an area code, our FillPhone "keystroke" procedure moves   
  you out of the field as soon as you enter a complete number.  If you 
  don't supply an area code, when you leave the field DoWait activates 
  our NormalizePhone procedure, which enters a default value of "415". 
  In either case, our NormalizePhone procedure will automatically      
  format the phone number with parentheses and a hyphen if necessary.  
    
  Enter a telephone number, with or without an area code.              
ͼ
   Endtext

Endproc
Writelib DemoLib CustPhoneBox
Release Procs CustPhoneBox

Proc EditCustBox()

   @ 14, 4
   SetMargin 4
   Text
ͻ
  When you arrive in the Cust table, DoWait calls our SetCustPrompt    
  procedure, which displays the top-level prompt you see now.          
                                                                       
  When you try to move to another customer record or press [F2],       
  DoWait activates EditCustRec.  EditCustRec requires you to enter     
  data in every field, then allows you to return to the Invoice table. 
    
  Enter information for a new customer.  Press [F2] to add them into   
  Cust or [Esc] to discard this input and return to the Invoice table. 
ͼ
   Endtext

Endproc
Writelib DemoLib EditCustBox
Release Procs EditCustBox

Proc ViewCustBox()

   @ 15, 4
   SetMargin 4
   Text
ͻ
  We've instructed DoWait to call our SetCustPrompt procedure when you 
  arrive in the Cust table.  Because you selected an existing customer 
  number for this invoice, SetCustPrompt made the Cust table a         
  display-only type of image.                                          
    
  Use the cursor movement keys to examine customer data.  Press [F3]   
  or [F4] to return to the Invoice table.                              
ͼ
   Endtext

Endproc
Writelib DemoLib ViewCustBox
Release Procs ViewCustBox

Proc CustNoBox()

   @ 8, 4
   SetMargin 4
   Text
ͻ
  DoWait invokes procedures when a user performs an action such as     
  leaving a field, moving to a new record, or pressing a designated    
  special key.  An application developer writes these procedures and   
  specifies the events or actions which trigger them.                  
                                                                       
  For example, we've instructed DoWait to call our GetCustNo procedure 
  when you attempt to leave the Customer No. field.  GetCustNo:        
  - fills in corresponding data if you enter an existing Customer No.  
  - prompts you to enter customer information if you enter a new       
    Customer No.                                                       
  - presents a customized message if you try to leave the field blank  
    
  Press [F1] to select a person from the current customer list, or     
  enter a new Customer No. to add a name to the master customer list.  
ͼ
   EndText

Endproc
Writelib DemoLib CustNoBox
Release Procs CustNoBox

Proc MethPaymntBox()

   @ 3, 15
   SetMargin 20
   Text
ͻ
  Here we've used the Toolkit's Popup procedure to   
  present you with a list of payment options.        
  When you attempt to leave the field, our ValidPay  
  procedure checks the option you select and takes   
  you to the fields for credit card information only 
  if you've selected a credit card.                  
                                                     
  To further demonstrate how the Toolkit can control 
  the data entry process, we've specified that you   
  must enter a value in this field.                  
    
  Press [F1] and select a method of payment.         
ͼ
   Endtext

Endproc
Writelib DemoLib MethPaymntBox
Release Procs MethPaymntBox

Proc CardNumHelp()
  TKMessage = "Enter any number and press Enter.  Press Del to cancel"
Endproc

Writelib DemoLib CardNumHelp
Release Procs CardNumHelp

Proc ExpirDateBox()

   @ 2, 20
   SetMargin 20
   Text
ͻ
  Paradox's built-in date validation ensures that      
  you enter a valid value in the Expiration Date       
  field.  In addition, DoWait passes every character   
  you type here to a customized "keystroke"            
  procedure called LeaveFullDate.                      
                                                       
  When you've entered a 2-digit year, LeaveFullDate:   
      - gives you a warning if the credit card has     
        expired                                        
      - moves you directly to the order section on     
        the second page of this form if the date is    
        valid (today or in the future).  Notice you do 
        not need to press Enter to leave this field.   
    
  Enter a date in any Paradox date format.             
ͼ
   Endtext

Endproc
Writelib DemoLib ExpirDateBox
Release Procs ExpirDateBox

Proc ShipViaBox()

   @ 0, 4
   SetMargin 4
   Text
ͻ
  When you move out of the Ship Via field, DoWait activates our field  
  "depart" procedure which checks for invalid carrier services and     
  also updates the Total field.  You may exit the field while it is    
  empty, but you must enter a value before posting an invoice record.  
                                                                       
  Press this key:           In Ship Via to:                            
      PgUp              Return to the first page of invoice data       
      Up or Left        Move to the order records for this invoice     
      Enter or Tab      Confirm this record is complete and post it    
    
  Press [F1] to select a carrier from the table below.  When you have  
  completed this invoice record, press Enter to post it.               
ͼ
   Endtext

Endproc
Writelib DemoLib ShipViaBox
Release Procs ShipViaBox

Proc OrdersBox()

   @ 10, 4
   SetMargin 4
   Text
ͻ
  Use [Enter], [Left] and [Right] to move among records in the Orders  
  table.  To complete a record, you'll need to enter values into       
  both the Item and Qty. fields.  Press [F2] or [Down] to move out of  
  the Orders table and into the Ship Via field of the Invoice table.   
                                                                       
  When you have completed a record and attempt to leave it, DoWait     
  activates our "record depart" procedure.  As you edit order records, 
  we use this procedure along with a "record arrival" procedure to:     
      - maintain record sequence as you insert and delete order data   
      - update the Amount fields and the invoice totals                
    
  Enter an Item number (using [F1] to get a list of valid numbers) and 
  a quantity.  Press [Down] when done entering order information.      
ͼ
   Endtext

Endproc
Writelib DemoLib OrdersBox
Release Procs OrdersBox
