; SCRIPT:     MKLIB.SC
; Version:   6.0a
; Date:       09 April, 1995  
;
;
; This script plays each of the scripts that contain procedures used in
; STOCKS and creates a library of procedures. Note that we use the library
; name of PARADOX, which is the default AUTOLIB.

LibName = "Paradox"
Autolib = LibName

IF Isfile(LibName+".lib")     ; Does AUTOLIB already exist?
    THEN MESSAGE LibName+".lib already exists"
         SHOWMENU "NO":"Don't overwrite existing library",
                  "YES":"Overwrite existing library"
         TO Choice
         IF Choice = "NO" or Choice = "Esc"
              THEN MESSAGE "Cancelling creation of "+LibName+" library." sleep 1000
                   QUIT      ; Exit the script and don't create library
         ENDIF
ENDIF

; If we get to this point, library didn't exist, or user selected "YES"

MESSAGE "Writing new "+LibName+" library."
CREATELIB LibName
PLAY "Board"
WRITELIB LibName SeeBoard,ShowNSleep,SleepRefresh
PLAY "Ticker"
WRITELIB LibName AddChar,TickerTape,DoTicker
PLAY "Portfol"
WRITELIB LibName SpecificPort,SpecQuery1,AskPortName,PortMenu
PLAY "Holdings"
WRITELIB LibName PortAggr,PortPric,PortSum
PLAY "Graphs"
WRITELIB LibName GraphMenu,SaveOldGraph,DoGraph,Graph1,Graph2,Graph3,Graph4
PLAY "DoFeed"
WRITELIB LibName DoFeed,TryToInitialize,ClearBackground,PutMessage,
                 ClearMessage,Startup,TestWaitForInitialize,
                 TestInitialize,DoneInitialize,DoneFeed
MESSAGE LibName+" library created."

; Once we've gotten this far, we can PLAY "stocks" to start application
