program BarGraph;
{Draws the bargraph of Section 29.4}
{This version will not print the year labels (87-94)}
uses graph;
type salestype = array[1..10] of integer;
var Yfloor, Yceiling, Xleft, Xright: integer;
    GrDriver, GrMode: integer;
    sales: salestype;
    width, NumOfYrs, FirstYr, MaxSales: integer;
    title, XaxisTitle: string;

procedure FOUR_FIXED (var Yfloor,Yceiling,Xleft,Xright: integer);
  {sets borders for graph region}
  begin
    Yfloor := round (0.85 * GetMaxY);
    Yceiling := round (0.1 * GetMaxY);
    Xleft := round(0.1 * GetMaxX);
    Xright :=  GetMaxX
  end; {FOUR_FIXED}

procedure GETDATA (filename: string;
                   var sales:salestype;
                   var NumOfYrs, FirstYr, MaxSales:integer;
                   var title, xAxisTitle: string);
  var i: integer;
      SalesFile: text;
  begin
    assign (SalesFile, filename);
    reset (SalesFile);
    Maxsales := -1;
    readln (SalesFile, title);
    readln (SalesFile, XaxisTitle);
    readln (SalesFile, NumOfYrs);
    readln (SalesFile, FirstYr);
    for i := 1 to NumOfYrs do
      begin
        readln (SalesFile, sales[i]);
        if sales[i] > MaxSales then Maxsales := sales[i];
      end
  end; {GETDATA}

procedure DRAW_AXES;
  {Draws x and y axes and 2 hash marks on y-axis}
  var str1: string;
      Yhalf: integer;
  begin
    line(Xleft, Yfloor, Xright, Yfloor);         {x-axis}
    line(Xleft, Yfloor, Xleft, Yceiling);        {y-axis}

    line (Xleft- 10,Yceiling, Xleft + 10, Yceiling);  {hash}
    yhalf := Yceiling + (Yfloor - Yceiling)div 2;     {marks}
    line (Xleft - 10, Yhalf, Xleft + 10, Yhalf)
  end;  {DRAW_AXES}

procedure DRAW_BARS (sales: salestype;
                     NumOfYrs, MaxSales, width: integer);
  {For each year calculates opposite vertexes for that year's bar}
  {and then draws the bar.}
  var i, X1,X2,NumVertPixels, Ytop:integer;
  begin
    for i := 1 to NumOfYrs do
      begin
        X1 := Xleft + (2 * i - 1) * width;
        X2 := X1 + width;
        NumVertPixels := Round((Yfloor-Yceiling)/MaxSales*sales[i]);
        Ytop := Yfloor - NumVertPixels;
        bar (X1, YTop, X2, Yfloor)
      end {for}
  end; {DRAW_BARS}

procedure WRITE_LABELS (title, xAxisTitle: string;
                        MaxSales: integer);
  {Prints titles and labels top hash mark with MaxSales value.}
  var y: integer;
      str1: string;
  begin
    str (MaxSales:3,str1);
    outTextXY (Xleft - 50, Yceiling, str1);
    y := round( 0.01 * GetMaxY);
    SetTextStyle (0,0,2);
    OutTextXY (Xleft + 40, y, title);
    OutTextXY (Xleft + 60, round (0.95 * GetMaxY), xAxisTitle)
  end; {WRITE_LABELS}

begin {main}
  GrDriver := Detect;
  Initgraph (GrDriver, GrMode,'');
  FOUR_FIXED (Yfloor, Yceiling, Xleft, Xright);
  GETDATA ('sales.dat',sales,NumOfYrs,FirstYr,MaxSales,
                                      title,xAxisTitle);
  width := round ((Xright - Xleft)/(NumOfYrs * 2));
  DRAW_AXES;
  DRAW_BARS (sales, NUmOfYrs, MaxSales, width);
  WRITE_LABELS (title, xAxisTitle, MaxSales);
  readln;
  closegraph
end.
