program ch28_p469;
type listtype = array[1..30] of integer;
var  list: listtype;
     first, last, i: integer;

procedure QUICKSORT (var list: listtype;
                     first, last: integer);
  {sorts an array recursively}
  var FocusIndex: integer;

  procedure SUBDIVIDE (var list: listtype;
                       first, last: integer;
                       var FocusIndex: integer);
    {puts focus value in its correct position;}
    {elements smaller than focus value will be to its left;}
    {those larger to its right}
    var focus: integer; {or whatever type of elements in array}
        left, right: integer;

    procedure SWITCH (var x, y: integer);
      {switches the values of x and y}
      var temp: integer;
      begin
        temp := x;
        x := y;
        y := temp
      end; {SWITCH}

    begin {SUBDIVIDE}
      focus := list[first];
      left := first;
      right := last;
      repeat
        {mark next value on left larger than focus}
         while (list[left] <= focus) and (left < last) do
          left := left + 1;
        {mark next value on right less than or equal to focus}
        while list[right] > focus do
          right := right - 1;
        if left < right then
          SWITCH (list[left], list[right])
      until left >= right;
      {put focus in its correct position}
      SWITCH (list[first], list[right]);
      FocusIndex := right
    end; {SUBDIVIDE}

  begin {QUICKSORT}
    if first < last then
      begin
        SUBDIVIDE (list, first, last, FocusIndex);
        QUICKSORT (list, first, FocusIndex - 1);
        QUICKSORT (list, FocusIndex + 1, last)
      end
  end; {QUICKSORT}

begin {main}
  list[1] := 34;       list[2] := 12;        list[3] := 95;
  list[4] := 3;        list[5] := 123;       list[6] := 101;
  list[7] := 74;       list[8] := 373;       list[9] := 55;

  first := 1;
  last := 9;
  QUICKSORT (list, first, last);
  writeln ('The sorted array is:');
  for i := 1 to last do
    writeln (list[i])
end.