program GetSmart;
{computer is supplied with a learning procedure}
type moverange = 0..10;
     valuestype = array[moverange] of integer;
     movestype = array[1..5] of moverange;
var winner: string;
    values: valuestype;
    moves: movestype;
    count, i: integer;
    answer: char;

procedure PLAYGAME (values: valuestype;
                    var winner: string;
                    var count: integer;
                    var moves: movestype);
  {plays one game}
  var  left_by_human, left_by_comp: moverange;

  function COMP_LEAVES (number: moverange;
                        values: valuestype): moverange;
    {used by computer to select its move}
    begin
      if number = 1 then
        COMP_LEAVES := 0
      else if values[number - 1] >= values[number - 2]
             then COMP_LEAVES := number - 1
             else COMP_LEAVES := number - 2
    end; {COMP_LEAVES}

  begin {PLAYGAME}
    writeln ('Start game. There are 10 matches.');
    count := 0;
    repeat
      write ('How many do you leave? ');
      readln (left_by_human);
      if left_by_human > 0 then
        begin
          left_by_comp := COMP_LEAVES (left_by_human, values);
          writeln ('  Computer leaves ', left_by_comp);
          count := count + 1;
          moves[count] := left_by_comp
        end {then}
    until (left_by_human = 0) or (left_by_comp = 0);
    if left_by_comp = 0
      then winner := 'human'
      else winner := 'computer';
    writeln (winner, ' won')
  end; {PLAYGAME}

procedure UPDATEVALUES (var values: valuestype;
                        winner: string;
                        count: integer;
                        moves: movestype);
  {updates the array values}
  var adjust, i: integer;
  begin
    if winner = 'computer' then adjust := 1
                           else adjust := -1;
    for i := 1 to count do
      values[moves[i]] := values[moves[i]] + adjust
  end; {UPDATEVALUES}

begin {main}
  for i := 0 to 8 do    {initialize}
    values[i] := 0;
  repeat
    PLAYGAME (values, winner, count, moves);
    UPDATEVALUES (values, winner, count, moves);
    write ('Shall we play again--y / n? ');
    readln (answer)
  until answer = 'n'
end.




