program CarSales;
{uses an array of counters with enumerated type subscripts}
type cars = (Chevy, Buick, Olds, Cadillac);
     CountsType = array[cars] of integer;
     StringsType = array[cars] of string[20];

var CarCounts: CountsType;
    CarStrings: StringsType;

procedure INITIALIZE (var CarCount: countsType;
                      var CarStrings: StringsType);
  {sets counters = 0 and puts car names in array}
  var car: cars;
  begin
    for car := Chevy to Cadillac do
      CarCounts[car] := 0;
    CarStrings[Chevy] := 'Chevrolet';
    CarStrings[Buick] := 'Buick';
    CarStrings[Olds] := 'Oldsmobile';
    CarStrings[Cadillac] := 'Cadillac'
  end;

procedure PROCESS (var CarCounts: CountsType);
  {processes the car sales file}
  var CarFile: text;
      CarCode: integer;
      car: cars;
  begin
    assign (CarFile,'carsale.dat');
    reset (CarFile);
    while not seekeof (CarFile) do
      begin
        read (CarFile, CarCode);
        if (CarCode < 1) or (CarCode > 4) then
          writeln ( 'Invalid entry ', CarCode)
        else
          begin
            car := cars (CarCode - 1);
            CarCounts[car] := CarCounts[car] + 1
          end
      end;
    close (CarFile)
  end; {PROCESS}

procedure RESULTS (CarCounts: CountsType;
                   CarStrings: StringsType);
  {print final results}
  var car: cars;
  begin
    writeln ('Number of each kind sold');
    for car := Chevy to Cadillac do
      writeln (CarStrings[car], ' ',CarCounts[car])
  end;  {RESULTS}

begin  {main}
  INITIALIZE (CarCounts, CarStrings);
  PROCESS (CarCounts);
  RESULTS (CarCounts, CarStrings)
end.

