program IQ_Correlation;
{average IQ for people born in warm season vs cold season}
var  wsum, wcount, csum, ccount: integer;
     month, day, IQ: integer;
     season: string;
     BirthFile: text;

function FINDSEASON (month, day: integer): string;
  {finds the season based on month and day}
  begin
    case month of
      1,2    : FINDSEASON := 'winter';
      4,5    : FINDSEASON := 'spring';
      7,8    : FINDSEASON := 'summer';
      10,11  : FINDSEASON := 'fall';
      3      : if day < 21 then FINDSEASON := 'winter'
                           else FINDSEASON := 'spring';
      6      : if day < 21 then FINDSEASON := 'spring'
                           else FINDSEASON := 'summer';
      9      : if day < 21 then FINDSEASON := 'summer'
                           else FINDSEASON := 'fall';
      12     : if day < 21 then FINDSEASON := 'fall'
                           else FINDSEASON := 'winter'
    end {case}
  end; {FINDSEASON}

procedure UPDATE_STATS (IQ: integer;
                        var wsum, wcount: integer;
                        var csum, ccount: integer);
  {updates appropriate summing and counting variables}
  var season: string;
  begin
    season := FINDSEASON (month, day);
    if (season = 'spring') or (season = 'summer') then
      begin
        wsum := wsum + IQ;
        wcount := wcount + 1
      end {then}
    else
      begin
        csum := csum + IQ;
        ccount := ccount + 1
      end {else}
  end; {UPDATE_STATS}

begin {main}
  assign (BirthFile, 'birth.dat');
  reset (BirthFile);
  wsum := 0;   wcount := 0;   csum := 0;   ccount := 0;
  while not seekeof (BirthFile) do
    begin
      readln (BirthFile, month, day, IQ);
      UPDATE_STATS (IQ, wsum, wcount, csum, ccount)
    end; {while}
  if wcount > 0
    then writeln ('Warm IQ average ', wsum / wcount:6:1)
    else writeln ('No warm statistics');
  if ccount > 0
    then writeln ('Cold IQ average ', csum / ccount:6:1)
    else writeln ('No cold statistics');
  close (Birthfile)
end.
