// Copyright (c) 1993 Rhino Publishing Ltd. All Rights Reserved

#include "oops.ch"
#include "box.ch"
memvar getlist

class window inherit box
	var oRecord						// attatch a record object to the window
	var aRow							// array of rows for field gets
	var aCol                   // array of columns for field gets
	var cText                  // window text

	message cls( nUseBack)
	message atSay( nRow, nCol, nText, lDisplay )
	message display()
	message edit()

end class

method cls( nUseBack )
	if nUseBack == nil .or. nUseBack		// default to true
		::super():display()
	else
		@ ::nTop, ::nLeft, ::nBottom, ::nRight box B_DOUBLE
	endif
	::cText := saveScreen( ::nTop, ::nLeft, ::nBottom, ::nRight )
return( self )

method atSay( nRow, nCol, nText, lDisplay )
	dispbegin()
	restScreen( ::nTop, ::nLeft, ::nBottom, ::nRight, ::cText )
	@ ::nTop+nRow, nCol+nCol say nText
	::cText := saveScreen( ::nTop, ::nLeft, ::nBottom, ::nRight )
	if lDisplay == nil .or. lDisplay
		::display()
	endif
	dispend()
return( self )

method display()
	::edit()
	clear gets
return( self )

method edit()
	local i
	restScreen( ::nTop, ::nLeft, ::nBottom, ::nRight, ::cText )
	for i = 1 to len( ::oRecord:aFields )
		@ ::nTop+::aRow[i], ::nLeft+::aCol[i] get ::oRecord:aFields[i]
	next i
return( self )

