// Copyright (c) 1993 Rhino Publishing Ltd. All Rights Reserved
// Test box routine

#include "inkey.ch"
#define K_CTRL_UP		397
#define K_CTRL_DOWN	401

function tBoxClr
   local oBox, nKey
   // first create a box object

   oBox := BoxClr():init(2,2, 10, 10)

   // pass it onto the moveIt handler
   cls
   while (nKey := inkey(0) ) != K_ESC
      moveIt( oBox, nKey )
      oBox:display()
   end
   cls
return( nil )

function moveIt( o, nKey )
   do case
   case nKey == K_UP
      o:up()
   case nKey == K_DOWN
      o:down()
   case nKey == K_RIGHT
      o:right()
   case nKey == K_LEFT
      o:left()
   case nKey == K_CTRL_UP
      o:SizeUp()
   case nKey == K_CTRL_DOWN
      o:sizeDown()
   case nKey == K_CTRL_RIGHT
      o:sizeRight()
   case nKey == K_CTRL_LEFT
      o:sizeLeft()
   otherwise
      o:char := chr( nKey )
   end case
return( nil )
