#include 'oops.ch'
#include 'inkey.ch'
#include 'box.ch'
#include 'menu.ch'

Static aMenus := {}
Static aScreens := {}
Static aCoords := {}
Static CurMenu 

Class Menu
   Var Prompts
   Var Current
   Var lConfigure
   Var Prompt

   Var BoxHeight
   Var BoxWidth

   Var BarHeight
   Var BarWidth
   Var Mode

   Var Row,Col

   // Menu Creation
   Message Init()
   Message EndInit()
   Message StartPopup(cPrompt,bWhen)
   Message EndPopup()
   Message AddItem(cPrompt,nKey,bWhen,bAction)
   Message AddSeperator()
   Message Include(oMenu)
   Message Configure()

   // Menu Execution
   Message Execute( nKey )
   Message GetAction( nKey )
   Message Display()
   Message Hilight()
   Message DeHilight()
   Message NextOption()
   Message PreviousOption()

End Class

Method Init()
   ::Prompts := {}
   ::Current := 1
   ::lConfigure := .F.
   ::BarHeight := ::BarWidth := ::BoxHeight := ::BoxWidth := 0
   PushPopup()
   CurMenu := Self
   ::Mode := STYLE_PULLDOWN
   ::Row := ::Col := 0
Return Self

Method EndInit()
   PullPopup()
   ::Configure()
Return NIL

Method StartPopup( cPrompt,bWhen )
   Local oMenu
   Local oldMenu := CurMenu
   oldMenu:AddItem( cPrompt,,bWhen )
   oMenu := Menu():Init()
   oldMenu:Prompts[ Len( oldMenu:Prompts ) ]:Action := oMenu
   oMenu:Prompt := oldMenu:Prompts[ Len( oldMenu:Prompts )]
Return NIL

Method EndPopup()
   CurMenu:Configure()
   PullPopup()
Return NIL

Method AddItem( cPrompt,nKey,bWhen,bAction )
   Local oPrompt
   AADD( CurMenu:Prompts, (oPrompt := Prompt():Init( cPrompt,nKey,bWhen,bAction ) ) )
   oPrompt:Menu := CurMenu
Return NIL

Method AddSeperator()
   If Len( CurMenu:Prompts ) > 0
      AADD( CurMenu:Prompts,Seperator() )
   Endif
Return NIL

Method Include( oMenu )
   Local nMax := Len( oMenu:Prompts )
   Local i
   For i = 1 To nMax
      AADD( CurMenu:Prompts,oMenu:Prompts[i] )
   Next i
Return NIL

Method Configure()
   Local i
   If !::lConfigure
      ::BarWidth := 80
      ::BoxHeight := Len( ::Prompts )
      For i = Len( ::Prompts ) To 1 Step -1
         If !::Prompts[i] == Seperator()
            ::BoxWidth := MAX( ::BoxWidth,Len(::Prompts[i]:Prompt ) )
            ::BarHeight += Len( ::Prompts[i]:Prompt )+1
            If VALTYPE( ::Prompts[i]:Action ) = 'O'
               ::Prompts[i]:Action:Configure()
            Endif
         Endif
      Next i
      ::BarHeight := INT( (::BarHeight+79)/80 )
      ::lConfigure := .T.
   Endif
Return NIL


Method Display()
   Local i,nLen := Len( ::Prompts )
   Local oPrompt
   Do Case
   Case ::Mode == STYLE_PULLDOWN
      ::Col := 1
      @ ::Row,0,::Row+::BarHeight-1,80 Box Space(9) COLOR COL_FRAME
      For i = 1 To nLen
         If ::Row+::BarHeight-1 > MAXROW()
            ::Row := MAXROW()-::BarHeight+1
         Endif
         oPrompt := ::Prompts[i]
         If !oPrompt == Seperator()
            If ::Col+Len( oPrompt:Prompt ) > 80
               ::Col := 1
               ::Row ++
            Endif
            If EVAL( oPrompt:When )
               @ ::Row,::Col Say oPrompt:Prompt COLOR COL_PROMPT
               @ ::Row,::Col+oPrompt:KeyPos-1 Say oPrompt:Letter COLOR COL_KEY
            Else
               @ ::Row,::Col Say oPrompt:Prompt COLOR COL_UNPROMPT
            Endif
            ::Col += Len( oPrompt:Prompt )+1
         Endif
      Next i
      ::Col := 1
      ::Row -= ::BarHeight-1
   Case ::Mode = STYLE_POPUP
      If ::Row+::BoxHeight+2 > MAXROW()
         ::Row := MAXROW()-::BoxHeight-2
      Endif
      If ::Col+::BoxWidth+3 > MAXCOL()
         ::Col := MAXCOL()-::BoxWidth-3
      Endif
      @ ::Row,::Col,::Row+::BoxHeight+1,::Col+::BoxWidth+3 Box B_SINGLE+' ' COLOR COL_FRAME
      ::Row++
      For i = 1 To nLen
         oPrompt := ::Prompts[i]
         If !oPrompt == Seperator()
            If EVAL( oPrompt:When )
               @ ::Row,::Col+2 Say oPrompt:Prompt COLOR COL_PROMPT
               @ ::Row,::Col+oPrompt:KeyPos+1 Say oPrompt:Letter COLOR COL_KEY
               If VALTYPE(oPrompt:Action) == 'O'
                  If ::Col+::BoxWidth+oPrompt:Action:BoxWidth+5 < MAXCOL()
                     @ ::Row,::Col+::BoxWidth+2 Say '' COLOR COL_PROMPT
                  Else
                     @ ::Row,::Col+1 Say '' COLOR COL_PROMPT
                  Endif
               Endif
            Else
               @ ::Row,::Col+2 Say oPrompt:Prompt COLOR COL_UNPROMPT
            Endif
         Else
            @ ::Row,::Col Say ''+Repl('',::BoxWidth+2)+'' COLOR COL_FRAME
         Endif
         ::Row ++
      Next i
      ::Row -= nLen+1
   EndCase
Return NIL

Method Execute( xKey )
   Static nLevel := 0
   Static bBlock
   Static nKey

   Local lWasSTYLE_PULLDOWN := ::Mode == STYLE_PULLDOWN
   Local nOldRow := ::Row
   Local nOldCol := ::Col
   Local nPos,oPrompt

   nLevel ++

   ::Current := MAX( 1,::Current )

   If nLevel > 1
      ::Mode := STYLE_POPUP
      ::Row := ATAIL( aCoords )[1]
      ::Col := ATAIL( aCoords )[2]+ATAIL( aCoords )[3] +3
      If !(::Col+::BoxWidth+2 < MAXCOL())
         ::Col := (ATAIL( aCoords )[2]-::BoxWidth)-3
      Endif
   Else
      bBlock := NIL
      nKey := 0
      If ::Mode == STYLE_PULLDOWN
         ::Row := 0
         ::Col := 1
         ::Current := 0
      Endif
   Endif

   PushScreen()

   ::Display()
   If ::Current > 0
      ::Hilight()
   Endif

   Do While bBlock == NIL
      If xKey == NIL
         nKey := Inkey(0)
      Else
         If ( bBlock := ::GetAction( xKey ) ) == NIL
            If ( nPos := ASCAN( ::Prompts,{|x|IF( x == Seperator(),.F.,;
                                              xKey == ALTKEY(x:Letter) .and.;
                                              EVAL(x:When) ) } ) ) > 0
               ::Current := nPos-1
               ::NextOption()
               ::Hilight()
               Keyboard Chr(13)
            Else
               Exit
            Endif
            xKey := NIL
         Endif
      Endif
      Do Case
      Case nKey == K_ESC
         Exit
      Case nKey == K_ENTER .and. EVAL( ::Prompts[ ::Current ]:When )
         If VALTYPE( ::Prompts[::Current]:Action ) = 'O'
            If ::Mode == STYLE_POPUP
               PushCoords( ::Row+::Current,::Col,::BoxWidth )
            Else
               PushCoords( ::Row+::BarHeight,::Col,-4 )
            Endif
            ::Prompts[::Current]:Action:Execute()
            PullCoords()
            Do Case
            Case nKey == K_ESC
               Exit
            Case nKey == K_RIGHT
               // Next Menu
               If nLevel == 1
                  nKey := 0
                  If ::Mode == STYLE_PULLDOWN
                     ::Dehilight()
                     ::NextOption()
                     ::Hilight()
                     oPrompt := ::Prompts[::Current]
                     If VALTYPE(oPrompt:Action) == 'O' .and. EVAL( oPrompt:When )
                        KeyBoard Chr(13)
                     Endif
                  Endif
               Else
                  Exit
               Endif
            Case nKey == K_LEFT
               // Previous Menu
               If nLevel == 1
                  nKey := 0
                  If ::Mode == STYLE_PULLDOWN
                     ::Dehilight()
                     ::PreviousOption()
                     ::Hilight()
                     oPrompt := ::Prompts[::Current]
                     If VALTYPE(oPrompt:Action) == 'O' .and. EVAL( oPrompt:When )
                        KeyBoard Chr(13)
                     Endif
                  Endif
               Else
                  Exit
               Endif
            EndCase
         Else
            bBlock := ::Prompts[::Current]:Action
         Endif
      Case nKey == K_DOWN .and. ::Mode == STYLE_POPUP
         // Down One
         ::Dehilight()
         ::NextOption()
         ::Hilight()
      Case nKey == K_UP .and. ::Mode == STYLE_POPUP
         // Up One
         ::Dehilight()
         ::PreviousOption()
         ::Hilight()
      Case CHR(nKey) == '-' .and. ::Mode == STYLE_POPUP
         Exit
      Case CHR(nKey) == '+' .and. ::Mode == STYLE_POPUP
         oPrompt := ::Prompts[::Current]
         If VALTYPE(oPrompt:Action) == 'O' .and. EVAL( oPrompt:When )
            KeyBoard Chr(13)
         Endif
      Case nLevel > 1 .and. (nKey == K_LEFT .or. nKey == K_RIGHT)
         Exit
      Case nKey == K_LEFT .and. nLevel == 1 .and. ::Mode == STYLE_PULLDOWN
         ::DeHilight()
         ::PreviousOption()
         ::Hilight()
         oPrompt := ::Prompts[ ::Current ]
         If VALTYPE(oPrompt:Action) == 'O' .and. EVAL( oPrompt:When )
            KeyBoard Chr(13)
         Endif
      Case nKey == K_RIGHT .and. nLevel == 1 .and. ::Mode == STYLE_PULLDOWN
         ::DeHilight()
         ::NextOption()
         ::Hilight()
         oPrompt := ::Prompts[ ::Current ]
         If VALTYPE(oPrompt:Action) == 'O' .and. EVAL( oPrompt:When )
            KeyBoard Chr(13)
         Endif
      Case ::Mode == STYLE_POPUP .and. ( nPos := ASCAN( ::Prompts,{|x|IF( x == Seperator(),.F.,;
                                              ((nKey == ALTKEY(x:Letter) .or.;
                                               nKey == x:Key .or.;
                                               UPPER(CHR( nKey )) == UPPER(x:Letter))).and.;
                                               EVAL(x:When)) } ) ) > 0
         ::DeHilight()
         ::Current := nPos
         ::Hilight()
         Keyboard Chr(13)
      EndCase
   Enddo

   nLevel --

   If lWasSTYLE_PULLDOWN
      ::Mode := STYLE_PULLDOWN
      ::Row := nOldRow
      ::Col := nOldCol
   Endif

   If ::Current > 0
      ::Dehilight()
   Endif
   PullScreen()

Return bBlock

Method GetAction( nKey )
   Static nLevel := 0
   Local bBlock,i
   nLevel ++
   For i = 1 To Len( ::Prompts )
      If !::Prompts[i] == Seperator()
         If nKey == ::Prompts[i]:Key .and. EVAL( ::Prompts[i]:When )
            If VALTYPE( bBlock := ::Prompts[i]:Action ) == 'O'
               bBlock := NIL
            Else
               Exit
            Endif
         Endif
         If bBlock == NIL .and. EVAL( ::Prompts[i]:When ) .and. ;
                                VALTYPE( ::Prompts[i]:Action ) == 'O'
            If !( bBlock := ::Prompts[i]:Action:GetAction( nKey ) ) == NIL
               Exit
            Endif
         Endif
      Endif
   Next i
   nLevel --
Return bBlock

Method Hilight()
   Local oPrompt := ::Prompts[::Current]
   If ::Mode == STYLE_PULLDOWN
      If EVAL( oPrompt:When )
         @ ::Row,::Col Say oPrompt:Prompt COLOR COL_HIPROMPT
         @ ::Row,::Col+oPrompt:KeyPos-1 Say oPrompt:Letter COLOR COL_HIKEY
      Else
         @ ::Row,::Col Say oPrompt:Prompt COLOR COL_UNHIPROMPT
      Endif
   Else
      If EVAL( oPrompt:When )
         @ ::Row+::Current,::Col+1 Say Left(' '+oPrompt:Prompt+Space(::BoxWidth+2),::BoxWidth+2) COLOR COL_HIPROMPT
         @ ::Row+::Current,::Col+oPrompt:KeyPos+1 Say oPrompt:Letter COLOR COL_HIKEY
         If VALTYPE(oPrompt:Action) == 'O'
            If ::Col+::BoxWidth+oPrompt:Action:BoxWidth+5 < MAXCOL()
               @ ::Row+::Current,::Col+::BoxWidth+2 Say '' COLOR COL_HIPROMPT
            Else
               @ ::Row+::Current,::Col+1 Say '' COLOR COL_HIPROMPT
            Endif
         Endif
      Else
         @ ::Row+::Current,::Col+1 Say Left(' '+oPrompt:Prompt+Space(::BoxWidth+2),::BoxWidth+2) COLOR COL_UNHIPROMPT
      Endif
   Endif
Return NIL

Method DeHilight()
   Local oPrompt := ::Prompts[::Current]
   If ::Mode == STYLE_PULLDOWN
      If EVAL( oPrompt:When )
         @ ::Row,::Col Say oPrompt:Prompt COLOR COL_PROMPT
         @ ::Row,::Col+oPrompt:KeyPos-1 Say oPrompt:Letter COLOR COL_KEY
      Else
         @ ::Row,::Col Say oPrompt:Prompt COLOR COL_UNPROMPT
      Endif
   Else
      If EVAL( oPrompt:When )
         @ ::Row+::Current,::Col+1 Say Left(' '+oPrompt:Prompt+Space(::BoxWidth+2),::BoxWidth+2) COLOR COL_PROMPT
         @ ::Row+::Current,::Col+oPrompt:KeyPos+1 Say oPrompt:Letter COLOR COL_KEY
         If VALTYPE(oPrompt:Action) == 'O'
            If ::Col+::BoxWidth+oPrompt:Action:BoxWidth+5 < MAXCOL()
               @ ::Row+::Current,::Col+::BoxWidth+2 Say '' COLOR COL_PROMPT
            Else
               @ ::Row+::Current,::Col+1 Say '' COLOR COL_PROMPT
            Endif
         Endif
      Else
         @ ::Row+::Current,::Col+1 Say Left(' '+oPrompt:Prompt+Space(::BoxWidth+2),::BoxWidth+2) COLOR COL_UNPROMPT
      Endif
   Endif
Return NIL

Method NextOption()
   Local i,oPrompt
   ::Current ++
   Do While .T.
      If ::Current > Len( ::Prompts )
         ::Current := 1
      Endif
      If !::Prompts[::Current] == Seperator()
         Exit
      Endif
      ::Current ++
   Enddo
   If ::Mode == STYLE_PULLDOWN
      // Calculate New Row & Column
      ::Row := 0
      ::Col := 1
      For i = 1 To ::Current -1
         If ::Row+::BarHeight-1 > MAXROW()
            ::Row := MAXROW()-::BarHeight+1
         Endif
         oPrompt := ::Prompts[i]
         If !oPrompt == Seperator()
            If ::Col+Len( oPrompt:Prompt ) > 80
               ::Col := 1
               ::Row ++
            Endif
            ::Col += Len( oPrompt:Prompt )+1
         Endif
      Next i
   Endif
Return NIL

Method PreviousOption()
   Local i,oPrompt
   ::Current --
   Do While .T.
      If ::Current == 0
         ::Current := Len( ::Prompts )
      Endif
      If !::Prompts[::Current] == Seperator()
         Exit
      Endif
      ::Current --
   Enddo
   If ::Mode == STYLE_PULLDOWN
      // Calculate New Row & Column
      ::Row := 0
      ::Col := 1
      For i = 1 To ::Current -1
         If ::Row+::BarHeight-1 > MAXROW()
            ::Row := MAXROW()-::BarHeight+1
         Endif
         oPrompt := ::Prompts[i]
         If !oPrompt == Seperator()
            If ::Col+Len( oPrompt:Prompt ) > 80
               ::Col := 1
               ::Row ++
            Endif
            ::Col += Len( oPrompt:Prompt )+1
         Endif
      Next i
   Endif
Return NIL

// Prompt Class -------------------------------------------------------------
Class Prompt
   Var Prompt
   Var When
   Var Action
   Var Letter
   Var Key
   Var KeyPos
   Var Menu

   Message Init Method pInit( cPrompt,nKey,bWhen,bAction )
End Class


Method pInit( cPrompt,nKey,bWhen,bAction )
   Local nPos
   nPos := AT('&',cPrompt )
   ::Letter := IF( nPos > 0,Substr( cPrompt,nPos+1,1 ) , Left( cPrompt,1 ) )
   ::Prompt := IF( nPos > 0, Left( cPrompt,nPos-1)+Right( cPrompt,Len(cPrompt)-nPos),;
                   cPrompt )
   ::When := IF( bWhen == NIL,{||.T.}, bWhen )
   ::Action := IF( bAction == NIL,{||NIL}, bAction )
   ::Key := nKey
   ::KeyPos := MAX( nPos,1 )
Return Self


// Seperator Class ----------------------------------------------------------
Static Function Seperator()
   Static xSep
   If xSep == NIL
      xSep := xSep()
   Endif
Return xSep

Class xSep
   Var xSep
End Class


// Other Functions ----------------------------------------------------------

Static Function PushPopup()
   AADD( aMenus,CurMenu )
Return NIL

Static Function PullPopup()
   CurMenu := ATAIL( aMenus )
   ASIZE( aMenus, Len( aMenus )-1 )
Return NIL

Static Function PushScreen()
   AADD( aScreens,SaveScreen(0,0,MAXROW(),MAXCOL() ) )
Return NIL

Static Function PullScreen()
   RestScreen( 0,0,MAXROW(),MAXCOL(),ATAIL( aScreens ) )
   ASIZE( aScreens,Len(aScreens)-1 )
Return NIL

Static Function PushCoords( x,y,z )
   AADD( aCoords,{x,y,z} )
Return NIL

Static Function PullCoords( x,y,z )
   ASIZE( aCoords,Len(aCoords)-1 )
Return NIL

Static Function ALTKEY( cLetter )
   LOCAL cSearch := 'QWERTYUIOP||||ASDFGHJKL|||||ZXCVBNM'+Repl("|",69)+'1234567890'
   LOCAL nAltKey

   If !cLetter = NIL
      If cLetter = ''
         nAltKey := 32
      Else
         If AT( Upper( cLetter ),cSearch ) > 0
            nAltKey := 271 + AT( Upper( cLetter ),cSearch )
         Else
            nAltKey := ASC( cLetter )
         Endif
      Endif
   Endif
Return nAltKey


