// Copyright (c) 1993 Rhino Publishing Ltd. All Rights Reserved

// Comments
#include "oops.ch"                     // required for oops syntax extensions
#include "box.ch"								// box drawing characters

class box
   var nTop
   var nLeft

	var nBottom
	var nRight
	var char										// fill character

   message init( t, l, b, r)             // initialise the object
   message up()                        // move the box up
   message down()                      // move the down down
   message left method moveleft()      // move left, note left if reserved word
	message right method moveright()		// move right, note right is reserved word
	message display()
end class

method init( t, l, b, r )
	::nTop := t
	::nLeft := l
	::nBottom := b
	::nRight := r
	::char := ""								// default to a point
return( self )                         // always do this in an initialisation routine

method up()
   ::nTop --
	::nBottom --
return( self )

method down()
   ::nTop ++
	::nBottom ++
return( self )

method moveRight()
	::nRight ++
	::nLeft ++
return( self )
method moveleft()
	::nRight --
	::nLeft --
return( self )

method display()
	@ ::nTop, ::nLeft, ::nBottom, ::nRight box B_DOUBLE+::char
return( self )
