#include 'box.ch'
#include 'inkey.ch'

#define K_SPACE 32

Function PickColor( cColor )
   Local cScreen := SaveScreen( 0,38,24,79 )
   Local nCursor := SETCURSOR(0)
   Local aForeColors := {'N','N+','B','B+','R','R+','G','G+','BR','BR+','GR','GR+','BG','BG+','W','W+'}
   Local aBackColors := {'N','B','R','G','BR','GR','BG','W'}
   Local oldColor := SetColor('W/N')
   Local nList := 1
   Local lFlash := .F.
   Local nFore
   Local nBack
   Local nPos
   Local nKey
   Local cTopic := GetTopic()

   SetHelpTopic('PICKCOLOR')

   If !cColor == NIL
      SetColor( cColor )
   Endif
   cColor := SetColor()
   cColor := Left( cColor,AT(',',cColor)-1 )
   SetColor( oldColor )

   nFore := Left( cColor,AT('/',cColor)-1 )
   nBack := Right( cColor,Len( cColor )-AT('/',cColor) )

   If SETBLINK()
      If Right( nFore,1 )='*'
         lFlash := .T.
         nFore := Left( nFore,Len(nFore)-1)
      Elseif Right( nFore,2 )='*+'
         lFlash := .T.
         nFore := Left( nFore,Len(nFore)-2)+'+'
      Endif
   Else
      If Right( nBack,1 )='*'
         lFlash := .T.
         nBack := Left( nBack,Len(nBack)-1)
      Endif
   Endif

   nFore := ASCAN( aForeColors,nFore )
   nBack := ASCAN( aBackColors,nBack )

   @ 0,38,24,79 BOX B_DOUBLE+' ' COLOR 'W+/B'
   @ 0,50 Say ' Select A Colour ' COLOR 'B/W'

   @ 7,42 Say 'A:BLACK     ' COLOR 'N/W'
   @ 8,42 Say 'B:HI-BLACK  ' COLOR 'N+/W'
   @ 9,42 Say 'C:BLUE      ' COLOR 'B/N'
   @ 10,42 Say 'D:HI-BLUE   ' COLOR 'B+/N'
   @ 11,42 Say 'E:RED       ' COLOR 'R/N'
   @ 12,42 Say 'F:HI-RED    ' COLOR 'R+/N'
   @ 13,42 Say 'G:GREEN     ' COLOR 'G/N'
   @ 14,42 Say 'H:HI-GREEN  ' COLOR 'G+/N'
   @ 15,42 Say 'I:MAGENTA   ' COLOR 'RB/N'
   @ 16,42 Say 'J:HI-MAGENTA' COLOR 'RB+/N'
   @ 17,42 Say 'K:YELLOW    ' COLOR 'GR/N'
   @ 18,42 Say 'L:HI-YELLOW ' COLOR 'GR+/N'
   @ 19,42 Say 'M:CYAN      ' COLOR 'BG/N'
   @ 20,42 Say 'N:HI-CYAN   ' COLOR 'BG+/N'
   @ 21,42 Say 'O:WHITE     ' COLOR 'W/N'
   @ 22,42 Say 'P:HI-WHITE  ' COLOR 'W+/N'

   @ 7,63 Say '1:BLACK     ' COLOR 'W+/N'
   @ 8,63 Say '2:BLUE      ' COLOR 'W+/B'
   @ 9,63 Say '3:RED       ' COLOR 'W+/R'
   @ 10,63 Say '4:GREEN     ' COLOR 'W+/G'
   @ 11,63 Say '5:MAGENTA   ' COLOR 'W+/RB'
   @ 12,63 Say '6:YELLOW    ' COLOR 'W+/GR'
   @ 13,63 Say '7:CYAN      ' COLOR 'W+/BG'
   @ 14,63 Say '8:WHITE     ' COLOR 'W+/W'

   If SETBLINK()
      @ 20,57 Say 'Press <Space Bar>' COLOR 'BG/B'
      @ 21,57 Say 'To Toggle Blinking' COLOR 'BG/B'
      @ 22,57 Say 'On And Off' COLOR 'BG/B'
   Else
      @ 20,57 Say 'Press <Space Bar>' COLOR 'BG/B'
      @ 21,57 Say 'To Toggle Hi Colored' COLOR 'BG/B'
      @ 22,57 Say 'Background On And Off' COLOR 'BG/B'
   Endif


   Do While .T.
      ColorSample( aForeColor[nFore]+'/'+aBackColor[nBack]+IF(lFlash,'*',''),;
                   nList,nFore,nBack )
      nKey := Inkey(0)
      @ 6+nFore,39 Say '  ' COLOR 'W+/B'
      @ 6+nBack,60 Say '  ' COLOR 'W+/B'
      Do Case
      Case nKey = K_F1
         DefineHelp()
      Case nKey = K_ENTER
         // Update Color & Exit
         cColor := aForeColor[nFore]+'/'+aBackColor[nBack]+IF(lFlash,'*','')
         SetColor( cColor )
         cColor := SetColor()
         cColor := Left( cColor,AT(',',cColor)-1 )
         SetColor( oldColor )
         Exit
      Case nKey = K_ESC
         // Exit
         Exit
      Case nKey = K_UP
         // Up In List Bouse At Top
         If nList = 1
            nFore := IF( --nFore = 0,16,nFore )
         Else
            nBack := IF( --nBack = 0,8,nBack )
         Endif
      Case nKey = K_DOWN
         // Down In List Bouse At Bottom
         If nList = 1
            nFore := IF( ++nFore = 17,1,nFore )
         Else
            nBack := IF( ++nBack = 9,1,nBack )
         Endif
      Case nKey = K_HOME
         // First In List
         If nList = 1
            nFore := 1
         Else
            nBack := 1
         Endif
      Case nKey = K_END
         // Last In List
         If nList = 1
            nFore := 16
         Else
            nFore := 8
         Endif
      Case nKey = K_LEFT .or. nKey = K_RIGHT
         // Switch Lists
         If nList = 1
            nList := 2
         Else
            nList := 1
         Endif
      Case nKey = K_SPACE
         // Change Blink Or Hi Background
         lFlash := !lFlash
      Case (nPos := AT(UPPER(CHR( nKey )),'ABCDEFGHIJKLMNOP')) > 0
         // Move To The Color In Fore List
         If nList = 2
            nList := 1
         Endif
         nFore := nPos
      Case (nPos := AT(CHR( nKey ),'12345678')) > 0
         // Move To The Color In Back List
         If nList = 1
            nList := 2
         Endif
         nBack := nPos
      EndCase
   Enddo

   SetHelpTopic( cTopic )
   SetCursor( nCursor )
   RestScreen( 0,38,24,79,cScreen )
Return cColor


Static Function ColorSample( cColor,nList,nFore,nBack )
   @ 2,40,5,77 BOX B_SINGLE +' ' COLOR cColor
   @ 3,50 Say 'Currently Selected' COLOR cColor
   @ 4,56 Say 'Colour' COLOR cColor
   If nList = 1
      @ 6+nFore,39 Say '-' COLOR 'W+/B'
      @ 6+nBack,61 Say Chr(26) COLOR 'W+/B'
   Else
      @ 6+nFore,40 Say Chr(26) COLOR 'W+/B'
      @ 6+nBack,60 Say '-' COLOR 'W+/B'
   Endif
Return NIL

