#include 'oops.ch'
#include 'mouseven.ch'

Function BoxPromptNew( txt,when,action,key )
   Local mPrompt := Prompt():Init( txt,when,action,key )
Return mPrompt

Function BarPromptNew( col,txt,submenu )
   Local mPrompt := Prompt():BarInit( col,txt,submenu )
Return mPrompt

Class Prompt
   Var Top,Left,Bottom,Right
   Var Prompt
   Var SubMenu
   Var Menu
   Var When
   Var Action
   Var DisplayColor 
   Var UnDisplayColor 
   Var HiliteColor 
   Var UnHiliteColor 
   Var KeyColor 
   Var Key
   Var KeyValue
   Var KeyPos
   Var QuickKey
   Var Status
   Message BarInit( col,txt,submenu )
   Message Init( txt,when,action,key )
   Message Display()
   Message Hilite()
   Message Hit( nRow,nCol ) ACTION {|self,nRow,nCol| nRow = ::Top .and. nCol >= ::Left .and. nCol <= ::Right } 
   Message IsPrompt() ACTION {||.T.} 
End Class

Method BarInit( col,txt,submenu )
   ::Left := col
   ::DisplayColor := 'N/W'
   ::UnDisplayColor := 'N+/W'
   ::HiliteColor := 'W+/N'
   ::UnHiliteColor := 'N+/N'
   ::KeyColor := 'W+/W'
   ::KeyPos := AT( '~',txt )
   ::Prompt := Left( txt, AT('~',txt  )-1 ) + Right( txt,Len( txt )-AT( '~',txt ) )
   ::Key := Substr( txt,AT( '~',txt )+1,1 )
   submenu:Prompt := Self
   ::SubMenu := submenu
   ::Status := .T.
Return Self

Method Init( txt,when,action,key )
   ::DisplayColor := 'N/W'
   ::UnDisplayColor := 'N+/W'
   ::HiliteColor := 'W+/N'
   ::UnHiliteColor := 'N+/N'
   ::KeyColor := 'W+/W'
   ::KeyPos := AT( '~',txt )
   ::Prompt := Left( txt, AT('~',txt  )-1 ) + Right( txt,Len( txt )-AT( '~',txt ) )
   ::Key := Substr( txt,AT( '~',txt )+1,1 )
   ::When := IF( when = NIL,{||.T.},when ) 
   ::Action := IF( action = NIL,{||NIL},action ) 
   ::QuickKey := IF( key=NIL,0,key )
Return Self

Method Display()
   @ ::Top,::Left Say Space( ::Right-::Left+1 ) Color IF( ::Status,::DisplayColor,::UnDisplayColor )
   @ ::Top,::Left Say ::Prompt Color IF( ::Status,::DisplayColor,::UnDisplayColor )
   If ::Status
      @ ::Top,::Left+::KeyPos-1 Say ::Key Color ::KeyColor
   Endif
Return NIL

Method Hilite()
   @ ::Top,::Left Say Space( ::Right-::Left+1 ) Color IF( ::Status,::HiliteColor,::UnHiliteColor )
   @ ::Top,::Left Say ::Prompt Color IF( ::Status,::HiliteColor,::UnHiliteColor )
Return NIL


Class MenuLine
   Var Top,Left,Bottom,Right
   Message IsPrompt() ACTION {||.F.}
   Message Display() Method LineDisp()
   Message Hit() ACTION {||.F.} 
End Class

Method LineDisp()
   @ ::Top,::Left Say ''+Repl('',::Right-::Left-1 )+'' Color 'N/W'
Return NIL

