#command SET CURSOR <x:ON,OFF,&>                                        ;
      => SetCursor( if(Upper(<(x)>) == "ON", IF(ReadInsert(),1,3), 0) )

#include 'mouseven.ch'

#xtranslate oTopObject:Window:Top => oTopObject\[8\]\[1\]
#xtranslate oTopObject:Window:Left => oTopObject\[8\]\[2\]
#xtranslate oTopObject:Window:Bottom => oTopObject\[8\]\[3\]
#xtranslate oTopObject:Window:Right => oTopObject\[8\]\[4\]
#xtranslate oTopObject:Window:RelRow => oTopObject\[8\]\[7\]
#xtranslate oTopObject:Window:RelCol => oTopObject\[8\]\[8\]


STATIC oTopObject                          // Current Object In Operation
STATIC lContinue := .T.                    // Continue System Flag
STATIC lRetry                              // Retry Event Flag
STATIC oSaved := {}
STATIC aScreens := {}

STATIC ssave := 0
STATIC srest := 0
STATIC osave := 0
STATIC orest := 0

Static bBlock

//#define DEMO
#IFDEF DEMO
Static lMessage := .F.
#ENDIF

Function MenuHandler()
   //
   LOCAL nKey                              // Last INKEY() Value
   LOCAL nExtras                           // Alt,Shift and Ctrl Keys Pressed

   bBlock := NIL
   lContinue := .T.
   Set Cursor Off
   SetTopObject( BMMenu() )
   BMMenu():Display()
   PushTopObject('a')
#IFDEF DEMO
      If !lMessage()
         DoMessage()
      Endif
#ENDIF
   Do While lContinue .and. !oTopObject == NIL

      nExtras := Extras()

      If !( nKey := Inkey() ) = 0 
                                               // If A Key Has Been Pressed
         DISPBEGIN()

         lRetry := .T.

#IFDEF DEMO
         If !lMessage
            DoMessage(.F.)
         Endif
#ENDIF
         Do While lRetry
            lRetry := .F.
            oTopObject:Key( nKey,nExtras )         // Send Key To Current Object
         Enddo

         DISPEND()
         Clear Typeahead
      Else
         If !IS_ALT() .and. !InMenu()
#IFDEF DEMO
            If !lMessage
               DoMessage(.F.)
            Endif
#ENDIF
            oTopObject := NIL
         Endif
      Endif
   Enddo

   oSaved := {}
Return bBlock

Function SetBlock( b )
   bBlock := b
Return NIL


Function SetTopObject( oObject )
   oTopObject := oObject
Return NIL

Function GetTopObject()
Return oTopObject

Function SetRetry()
   lRetry := .T.
Return NIL

Function PushTopObject()
   AADD( oSaved,oTopObject )
Return NIL

Function PullTopObject()
   oTopObject := oSaved[ Len(oSaved) ]
   ASIZE( oSaved,Len(oSaved)-1 )
Return NIL

Function PopTopObject()
Return oSaved[ Len(oSaved) ]

Function Extras( lReport )
   LOCAL nKeys := 0
   If IS_ALT()
      nKeys += ALT
   Endif
   If IS_CTRL()
      nKeys += CTRL
   Endif
   If IS_SHIFT()
      nKeys += SHIFT
   Endif
Return nKeys

Function ALTKEY( cLetter )
   LOCAL cSearch := 'QWERTYUIOP||||ASDFGHJKL|||||ZXCVBNM'+Repl("|",69)+'1234567890'
   LOCAL nAltKey

   If !cLetter = NIL
      If cLetter = ''
         nAltKey := 32
      Else
         If AT( Upper( cLetter ),cSearch ) > 0
            nAltKey := 271 + AT( Upper( cLetter ),cSearch )
         Else
            nAltKey := ASC( cLetter )
         Endif
      Endif
   Endif
Return nAltKey

Function EndEvents()
   lContinue := .F.
Return NIL

Function PUSHSCREEN()
   AADD( aScreens,SaveScreen(0,0,MAXROW(),79) )
Return NIL

Function PULLSCREEN()
   RestScreen( 0,0,MAXROW(),79,aScreens[ Len(aScreens) ] )
   ASIZE( aScreens,Len(aScreens)-1)
Return NIL

Function POPSCREEN()
   RestScreen( 0,0,MAXROW(),79,aScreens[ Len(aScreens) ] )
Return NIL

Function ColorConv( cColor )
   Local cFore,cBack,cAttr,nAt
   cFore := Left( cColor , AT('/',cColor )-1 )
   cBack := Right( cColor , Len( cColor )-AT('/',cColor ) )
   If '*' $cFore
      nAt := AT( '*',cFore )
      cBack += '*'
      cFore := Left( cFore,nAt-1) +Right( cFore,Len( cFore )-nAt)
   Endif
   If '+' $cBack
      cFore += '+'
      cBack := Left( cBack,nAt-1) +Right( cBack,Len( cBack )-nAt)
   Endif
   cAttr := CHR( ColorNum( cFore )+( ColorNum( cBack )*16 ))
Return cAttr

Static Function ColorNum( cColor )
   Local nNum := 0
   If 'B' $cColor
      nNum += 1
   Endif
   If 'G' $cColor
      nNum += 2
   Endif
   If 'R' $cColor
      nNum += 4
   Endif
   If 'W' $cColor
      nNum := 7
   Endif
   If '+' $cColor .or. '*' $cColor
      nNum += 8
   Endif
Return nNum

Function HScroll( t,l,b,r,dir )
   Local cScreen
   If dir > 0
      cScreen := SaveScreen( t,l,b,r-dir )
      RestScreen( t,l+dir,b,r,cScreen )
   Else
      cScreen := SaveScreen( t,l-dir,b,r )
      RestScreen( t,l,b,r+dir,cScreen )
   Endif
Return NIL

#IFDEF DEMO
Static Function DoMessage( lRemove )
   Static cScr
   If lRemove == NIL
      cScr := SaveScreen( 5,17,19,61 )
      @ 05,17,19,61 BOX "ͻȺ " COLOR 'W+/B'
      @ 06,23 SAY "Rhino Publishing Proudly Presents" COLOR 'W+/B'
      @ 08,31 SAY "The Browse Manager" COLOR 'W+/B'
      @ 10,28 SAY "Written By Allen Bullen" COLOR 'W+/B'
      @ 12,31 SAY "Copyright (C) 1993" COLOR 'W+/B'
      @ 14,22,18,56 BOX "Ŀ " COLOR 'W/B'
      @ 14,36 SAY " Note " COLOR 'W/B'
      @ 15,24 SAY "This Is A Demonstration Version" COLOR 'W/B'
      @ 16,24 SAY "This Notice Does Not Appear In" COLOR 'W/B'
      @ 17,30 SAY "The Release Version" COLOR 'W/B'
   Else
      lMessage := .T.
      RestScreen( 5,17,19,61,cScr )
      cScr := NIL
   Endif
Return NIL
#ENDIF

