Function DBEditTOBM( nTop,nLeft,nBottom,nRight,;
                     aFieldList,bUserFunc,aPicture,;
                     aHeader,aHeadSep,aColSep,;
                     aFootSep,aFooter )

   Local oBBrowse,oBColumn,cUsePicture,cUseHead,cUseHSep,cUseColSep,cUseFoot
   Local cUseFSep,bBlock,i
   Local lAppend := .F.,nOldRow,nlen

   nTop := IF(VALTYPE(nTop)='N',nTop,0)
   nLeft := IF(VALTYPE(nLeft)='N',nLeft,0)
   nBottom := IF(VALTYPE(nBottom)='N',nBottom,MAXROW())
   nRight := IF(VALTYPE(nRight)='N',nRight,MAXCOL())


   oBBrowse := BMBROWSEDB( nTop,nLeft,nBottom,nRight )

   If !(VALTYPE(aFieldList) = 'A')
      nLen := Len( aFieldList := Array( FCOUNT() ) )
      AFIELDS( aFieldList )
   Endif

   ArrayConvert( @aPicture,'',nLen )
   ArrayConvert( @aColSep,'  ',nLen )
   oBBrowse:ColSep := '  '
   ArrayConvert( @aFootSep,'',nLen )
   ArrayConvert( @aFooter,'',nLen )
   oBBrowse:FootSep := ''
   ArrayConvert( @aHeadSep,'',nLen )
   oBBrowse:HeadSep := ''

   If !(VALTYPE(aHeader) = 'A')
      If VALTYPE(aHeader) = 'C'
         cUseHead := aHeader
         aHeader := Array( nLen )
         AFILL(aHeader,cUseHead)
      Else
         aHeader := Array( nLen )
         AEVAL(aHeader,{|x,n|aHeader[n]:=aFieldList[n]})
      Endif
   Endif


   For i = 1 to Len(aFieldList)
      Do Case
      Case EMPTY(aFieldList[i])
         bBlock := '{||NIL}'
      Case TYPE(aFieldList[i]) = 'M'
         bBlock := '{||"  <Memo>  "}'
      Otherwise
         If Len(aPicture[i]) > 0
            bBlock := '{||TRANSFORM('+aFieldList[i]+',"'+aPicture[i]+'")}'
         Else
            bBlock := '{||'+aFieldList[i]+'}'
         Endif
      Endcase

      If !bBlock = NIL
         oBColumn := BMCOLUMNNEW(aHeader[i] , bBlock )
         oBColumn:colSep := aColSep[i]
         oBColumn:defColor := {2,3}
         oBColumn:cColor := AsArray(oBBrowse:ColorSpec)[2]+','+;
                            AsArray(oBBrowse:ColorSpec)[3]
         oBColumn:footing := aFooter[i]
         oBColumn:footSep := aFootSep[i]
         oBColumn:headSep := aHeadSep[i]

         oBBrowse:addColumn(oBColumn)
      Endif
   Next i

Return oBBrowse

******************************************************************************
******************************************************************************
Static Function ArrayConvert( aArray,cDefault,nLen )
   Local cUse
   If !(VALTYPE(aArray) = 'A')
      If VALTYPE(aArray) = 'C'
         cUse := cDefault
         aArray := Array( nLen )
         AFILL(aArray, cUse)
      Else
         aArray := Array( nLen )
         AFILL(aArray, cDefault)
      Endif
   Endif
Return NIL
