#include 'inkey.ch'

#command DEFAULT <x> To <y> => <x> := IF( <x> = NIL , <y> , <x> )

Static aMenu := {} 
Static aMenuCols := {'W/N','N/W','W/N','N/W','W/N','N+/N'} 

Function NewAtPrompt( nRow,nCol,cPrompt,cMess,bBlock )
   Local aPrompt := Array( 6 )

   default cMess To ''
   default bBlock To {||.T.} 

   aPrompt[1] := nRow
   aPrompt[2] := nCol

   If (aPrompt[6] := AT( '~',cPrompt)) > 0
      aPrompt[3] := Left( cPrompt,aPrompt[6]-1 )+Right( cPrompt,Len(cPrompt)-aPrompt[6] )
   Else
      aPrompt[3] := cPrompt
   Endif
   aPrompt[4] := cMess
   aPrompt[5] := bBlock

   Normal( aPrompt )

   AADD( aMenu,aPrompt )
Return NIL

Function NewMenuTo( bBlock,initvar )
   Local nCurrent := EVAL( bBlock )
   Local bKeyBlock
   Local nKey,nPos

   Default nCurrent To 1

   If ASCAN( aMenu,{|x|EVAL(x[5])} ) > 0
      Do While .T.
         Hilight( aMenu[ nCurrent ] )
         Message( aMenu[ nCurrent ][4] )
         EVAL( bBlock,nCurrent )
         nKey := Inkey(0)
         Do Case
         Case VALTYPE( bKeyBlock := SETKEY( nKey ) ) = 'B'
            // Set Keys
            EVAL( bKeyBlock,ProcName(1),ProcLine(1),UPPER(initvar) )
         Case nKey = K_ESC .and. SET( _SET_ESCAPE )
            // Leave if Escape is on
            nCurrent := 0
            Exit
         Case nKey = K_ENTER
            Exit
         Case nKey = K_UP .or. nKey = K_LEFT
            // Back One Option
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            Do While .T.
               nCurrent --
               If nCurrent = 0
                  If SET( _SET_WRAP )
                     nCurrent := Len( aMenu ) +1
                  Else
                     nCurrent := 1
                     Do While !EVAL( aMenu[ nCurrent ][5] )
                        nCurrent ++
                     Enddo
                     Exit
                  Endif
               Else
                  If EVAL( aMenu[ nCurrent ][5] )
                     Exit
                  Endif
               Endif
            Enddo
            Hilight( aMenu[ nCurrent] )
         Case nKey = K_DOWN .or. nKey = K_RIGHT
            // On One Option
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            Do While .T.
               nCurrent ++
               If nCurrent > Len( aMenu )
                  If SET( _SET_WRAP )
                     nCurrent := 0
                  Else
                     nCurrent := Len( aMenu )
                     Do While !EVAL( aMenu[ nCurrent ][5] )
                        nCurrent --
                     Enddo
                     Exit
                  Endif
               Else
                  If EVAL( aMenu[ nCurrent ][5] )
                     Exit
                  Endif
               Endif
            Enddo
            Hilight( aMenu[ nCurrent] )
         Case nKey = K_HOME .or. nKey = K_PGUP
            // First
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            nCurrent := 1
            Do While !EVAL( aMenu[ nCurrent ][5] )
               nCurrent ++
            Enddo
            Hilight( aMenu[ nCurrent] )
         Case nKey = K_END .or. nKey = K_PGDN
            // Last
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            nCurrent := Len( aMenu )
            Do While !EVAL( aMenu[ nCurrent ][5] )
               nCurrent --
            Enddo
            Hilight( aMenu[ nCurrent] )
         Case ( nPos := ASCAN( aMenu,{|x|UPPER(CHR(nKey))=UPPER(Substr(x[3],x[6],1)) .and. EVAL( x[5]) },nCurrent+1 ) ) > 0
            // One After Current Position
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            nCurrent := nPos 
            Hilight( aMenu[ nCurrent] )
            Message( aMenu[ nCurrent ][4] )
            If !(ASCAN( aMenu,{|x|UPPER(CHR(nKey))=UPPER(Substr(x[3],x[6],1)) .and. EVAL( x[5]) } ,,nPos-1) > 0 .or. ;
                 ASCAN( aMenu,{|x|UPPER(CHR(nKey))=UPPER(Substr(x[3],x[6],1)) .and. EVAL( x[5]) } ,nPos+1) > 0)
               // Not One Before or One After Current Position
               Exit
            Endif
         Case ( nPos := ASCAN( aMenu,{|x|UPPER(CHR(nKey))=UPPER(Substr(x[3],x[6],1)) .and. EVAL( x[5]) }) ) > 0
            // One After Current Position
            Normal( aMenu[ nCurrent ] )
            Message( aMenu[ nCurrent ][4],.T. )
            nCurrent := nPos 
            Hilight( aMenu[ nCurrent] )
            Message( aMenu[ nCurrent ][4] )
            If !ASCAN( aMenu,{|x|UPPER(CHR(nKey))=UPPER(Substr(x[3],x[6],1)) .and. EVAL( x[5]) } ,nPos+1) > 0
               // Not One After Current Position
               Exit
            Endif
         EndCase
      Enddo
      If nCurrent > 0
         Normal( aMenu[ nCurrent ] )
      Endif
   Else
      nCurrent := -1
   Endif
   aMenu := {}
Return nCurrent

Static Function Normal( aPrompt )
   If EVAL( aPrompt[5] )
      @ aPrompt[1],aPrompt[2] Say aPrompt[3] COLOR aMenuCols[1]
      If aPrompt[6] > 0
         @ aPrompt[1],aPrompt[2]+aPrompt[6]-1 Say Substr( aPrompt[3],aPrompt[6],1 ) ;
                                                        COLOR aMenuCols[2]
      Endif
   Else
      @ aPrompt[1],aPrompt[2] Say aPrompt[3] COLOR aMenuCols[6]
   Endif
Return NIL

Static Function HiLight( aPrompt )
   If EVAL( aPrompt[5] )
      @ aPrompt[1],aPrompt[2] Say aPrompt[3] COLOR aMenuCols[3]
      If aPrompt[6] > 0
         @ aPrompt[1],aPrompt[2]+aPrompt[6]-1 Say Substr( aPrompt[3],aPrompt[6],1 ) ;
                                                        COLOR aMenuCols[4]
      Endif
   Else
      @ aPrompt[1],aPrompt[2] Say aPrompt[3] COLOR aMenuCols[6]
   Endif
Return NIL

Static Function Message( cMess,lRemove )
   Default lRemove To .F.
   If Len( cMess ) > 0
      If lRemove
         If SET( _SET_MCENTER )
            @ SET( _SET_MESSAGE ),INT((MAXCOL()-Len(cMess))/2) ;
                        Say Space(Len(cMess)) COLOR aMenuCols[5]
         Else
            @ SET( _SET_MESSAGE ),0 Say Space(Len(cMess)) COLOR aMenuCols[5]
         Endif
      Else
         If SET( _SET_MCENTER )
            @ SET( _SET_MESSAGE ),INT((MAXCOL()-Len(cMess))/2) ;
                                    Say cMess COLOR aMenuCols[5]
         Else
            @ SET( _SET_MESSAGE ),0 Say cMess COLOR aMenuCols[5]
         Endif
      Endif
   Endif
Return NIL

Function SetMenuColors( c1,c2,c3,c4,c5,c6 )
   Default c1 To aMenuCols[1]
   Default c2 To aMenuCols[2]
   Default c3 To aMenuCols[3]
   Default c4 To aMenuCols[4]
   Default c5 To aMenuCols[5]
   Default c6 To aMenuCols[6]
   aMenuCols[1] := c1
   aMenuCols[2] := c2
   aMenuCols[3] := c3
   aMenuCols[4] := c4
   aMenuCols[5] := c5
   aMenuCols[6] := c6
Return NIL
