#include 'oops.ch'
#include "box.ch"

#command default <x> to <v> => if <x> == nil; <x> := <v>; endif

#IFNDEF CODE
   #xtranslate ::Cargo => Self\[1\]
   #xtranslate ::Width => Self\[2\]
   #xtranslate ::Block => Self\[3\]
   #xtranslate ::DefColor => Self\[4\]
   #xtranslate ::ColorBlock => Self\[5\]
   #xtranslate ::Heading => Self\[6\]
   #xtranslate ::HeadSep => Self\[7\]
   #xtranslate ::ColSep => Self\[8\]
   #xtranslate ::FootSep => Self\[9\]
   #xtranslate ::Footing => Self\[10\]
   #xtranslate ::cBlock => Self\[11\]
   #xtranslate ::cColor => Self\[12\]
#ENDIF

memvar getlist

function BMColumnNew( cHeading, xBlock )
return( BMColumn():init( cHeading, xBlock ) )

Class BMColumn

	// Actual TBColumn Stuff
	Var CARGO
 	Var WIDTH
  	Var BLOCK
  	Var DEFCOLOR
  	Var COLORBLOCK
  	Var HEADING
  	Var HEADSEP
  	Var COLSEP
   Var FOOTSEP
   Var FOOTING

   // New Stuff
   Var cBlock		// The Character Expression
   Var cColor      // The Colorblock expression

   Message Init( cHeading, xBlock )
   Message Configure()				// re-compile the expressions to codeblocks

   Message sizeLeft( qty )	    // default to 1
   Message sizeRight( qty )	// default to 1

   Message SetBlock( cBlock,bBlock )

end Class

method Init( cHeading, xBlock )
   local bBlock, xTest

   bBlock := fixBlock( xBlock )

   aCopy( TBColumnNew( cHeading, bBlock ), Self )

   ::cBlock := alltrim( xBlock )
   ::DefColor := {2,3} 

return( self )

method Configure()
   local colorTest
	if ::block == nil .and. valtype( ::cBlock ) == 'C'
      ::block := ctob( ::cBlock )
   endif
return( self )

method sizeLeft( qty )
	local val
	default qty to 1
   if ::width == nil
      // need to calculate the current setting
      ::width := checklen( self )
   endif

   if ::width - qty > 0
      ::width -= qty
   endif
return( self )

Method sizeRight( qty )
	default qty to 1
   if ::width == nil
      // need to calculate the current setting
      ::width := checklen( self )
   endif
   ::width += qty
return( self )

Method SetBlock( cBlock,bBlock )
   ::cBlock := cBlock
   If bBlock = NIL
      ::Block := NIL
      ::Configure()
   Endif
Return NIL


static function fixBlock( cBlock )
   local currentError := errorBlock(), err := .f.
   local bBlock, cMessage

	if valtype( cBlock ) == 'C'
      bblock := ctob( cBlock )		// Compile the codeblock
   else
      bBlock := cBlock
   endif

   currentError := errorBlock( {|o| cMessage := o:description, frigError( err := .t.) } )

   begin sequence
      eval( bBlock )
   end

   if err
      bBlock := { || cMessage }
   endif

   errorBlock( currentError )
return( bBlock )

static function frigerror( x )
   break
return( .f. )


/////////////////////////////////////////////////////////////////
****************
*
* STATIC Function CHECKLEN(oColumn)
*
* Purpose: To retreive the width of a TBColumn object depending on headings,
*          footings etc.
*
* Where:   oColumn is the TBColumn object
*
* Returns: The width of the TBColumn object
*
****************
Static Function CHECKLEN(oColumn)
   LOCAL nLength                      // width of column
   LOCAL nHeadLen                     // header length
   LOCAL nFootLen                     // footer length
   LOCAL nSemiPos                        // Current position of a ';'
   LOCAL nWorkString                        // Working string

   nHeadLen := 0                      // Default length of header
   nFootLen := 0                      // Default length of footer
   nSemiPos := 0                         // Assume no ';' in string
   if (nWorkString:=oColumn:heading)  != nil            // Current heading
   	If AT(';',nWorkString) > 0                                // Are there any ';' ?
         	Do While (nSemiPos:=AT(';',nWorkString)) > 0               // While there are no more
   	      nHeadLen := MAX(nHeadLen,nSemiPos-1)               // Check length against old
   	      nWorkString := Substr(nWorkString,nSemiPos+1,Len(nWorkString)-nSemiPos)   // Take off previous chars
   	   Enddo
   	Else
         	nHeadLen := Len(nWorkString)                         // Has no ';' assign length
   	Endif
   endif
   
   nSemiPos := 0                        // Reassign assuming no ';'
   if (nWorkString:=oColumn:footing) != nil            // Current footing
   
   	/*
   	  Now working the same way as before but on footer instead of header
   	*/
   	If AT(';',nWorkString) > 0
         	Do While (nSemiPos:=AT(';',nWorkString)) > 0
   	      nFootLen := MAX(nFootLen,nSemiPos-1)
             	nWorkString := Substr(nWorkString,nSemiPos+1,Len(nWorkString)-nSemiPos)
         	Enddo
   	Else
         	nFootLen := Len(nWorkString)
   	Endif
   endif
   
   
   nLength:=MAX(MAX(TYPELEN(oColumn:block),nHeadLen),;   // Find greater of nHeadLen,
               nFootLen)                               // nFootLen, or column
   
Return nLength      // width of column

****************
*
* Function TYPELEN(vValue)
*
* Purpose: To find the width of a code blocks result irrespective of data type
*
* Where: vValue is the code block created to retreive information for
*        display in the TBROWSE object
*
* Returns: The width of the passed code block
*
****************
Static Function TYPELEN(vValue)
   Local nLength:=0, val
   val := EVAL(vValue)
   Do Case
   Case Valtype(val) = 'C' // Result of code block is type Char
         nLength:=len(val)        // Take length
   Case Valtype(val) = 'D' // Result of code block is type Date
         nLength:=len(DTOC(val))  // Take length of string conversion
   Case Valtype(val) = 'N' // Result of code block is type Numeric
         nLength:=len(Str(val))   // Take length of string conversion
   Case Valtype(val) = 'L' // Result of code block is type Logical
         nLength:=1                           // Will always be 1
   Endcase
Return nLength   // Return width of code block
