unit WcMsgEX;

interface

uses
  Dos,
  WcType,
  Filer,
  WcMisc,
  WcDb,
  WcMsgDb,
  WcGlobal;

type
  PExMsgBase = ^TExMsgBase;
  TExMsgBase = object
    constructor Init;
    destructor Done; virtual;
    procedure Lock;
    procedure Unlock;
    function AddMsg(var Msg : TMsgHeader; MsgText : PMsgText; Conf : Word) : Boolean;
    procedure MarkMsgRead(conf, num: Word);
    procedure ProcessMsgs;
  private
    MsgFile   : File;
    LockCount : Word;
  end;

implementation

type
  TExMsgHeader = record
    What: (emwAddMsg, emwMarkMsgRead);
    Conference: Word;
    Msg: TMsgHeader;
  end;

const
  MsgExName = 'MSGEX.DAT';

  constructor TExMsgBase.Init;
  begin
    LockCount := 0;
    Assign(MsgFile, MwConfig.UserDataBasePath+MsgExName);
    Reset(MsgFile, 1);
    if IoResult <> 0 then
      begin
        Rewrite(MsgFile, 1);
        if IoResult <> 0 then
          Fail;
      end;
  end;

  destructor TExMsgBase.Done;
  begin
    Close(MsgFile);
  end;

  procedure TExMsgBase.Lock;

  var retries: Word;

  begin
    if LockCount = 0 then begin
      retries := 0;
      while not BTIsamLockRecord(0, 1, FileRec(MsgFile).Handle, 768, 64) do begin
        IsamDelay(Random(200));
        Inc(retries);
        if retries > 50 then
          LogFatalError('Error locking message database', IsamError);
        WriteTopRight('Lock retry #'+Long2Str(retries));
      end;
    end;
    Inc(LockCount);
  end;


  procedure TExMsgBase.Unlock;

  begin
    Dec(LockCount);
    if (LockCount = 0) and not BTIsamUnLockRecord(0, 1, FileRec(MsgFile).Handle) then
      LogFatalError('Error unlocking message database', IsamError);
  end;


  function TExMsgBase.AddMsg(var Msg : TMsgHeader; MsgText : PMsgText; Conf : Word) : Boolean;
  var
    Io : Word;
    emh: TExMsgHeader;
  begin
    AddMsg := False;
    emh.What := emwAddMsg;
    emh.Conference := Conf;
    emh.Msg := Msg;
    Lock;
    Seek(MsgFile, FileSize(MsgFile));
    Io := IoResult;
    if Io <> 0 then
      LogFatalError('Error seeking EXMsgBase', Io);
    BlockWrite(MsgFile, emh, SizeOf(TExMsgHeader));
    Io := IoResult;
    if Io <> 0 then
      LogFatalError('Error writing EXMsgBase header', Io);
    BlockWrite(MsgFile, Msgtext^, Msg.MsgBytes);
    if Io <> 0 then
      LogFatalError('Error writing EXMsgBase text', Io);
    UnLock;
    AddMsg := True;
  end;


  procedure TExMsgBase.MarkMsgRead(conf, num: Word);

  var emh: TExMsgHeader;
      Io: Integer;

  begin
    emh.What := emwMarkMsgRead;
    emh.Conference := conf;
    emh.Msg.MsgNumber := num;
    Lock;
    Seek(MsgFile, FileSize(MsgFile));
    Io := IoResult;
    if Io <> 0 then
      LogFatalError('Error seeking EXMsgBase', Io);
    BlockWrite(MsgFile, emh, SizeOf(TExMsgHeader));
    Io := IoResult;
    if Io <> 0 then
      LogFatalError('Error writing EXMsgBase header', Io);
    UnLock;
  end;


  procedure TExMsgBase.ProcessMsgs;
  var
    emh     : TExMsgHeader;
    MsgText : PMsgText;
    Io,
    Last    : Word;
    RefNr   : LongInt;

  begin
    Last  := $FFFF;
    RefNr := 1;

    New(MsgText);
    if MsgText = nil then
      LogFatalError('Could not allocate message buffer', 0);

    Seek(MsgFile, 0);

    Io := IoResult;
    if Io <> 0 then
      LogFatalError('Error seeking EXMsgBase file', Io);

    while not Eof(MsgFile) do
      begin
        BlockRead(MsgFile, emh, SizeOf(TExMsgHeader));
        Io := IoResult;
        if Io <> 0 then
          LogFatalError('Error reading EXMsgBase header', Io);
        if emh.What = emwAddMsg then begin
          BlockRead(MsgFile, MsgText^, emh.Msg.MsgBytes);
          Io := IoResult;
          if Io <> 0 then
            LogFatalError('Error reading EXMsgBase Text', Io);
        end;
        if emh.Conference <> Last then
          begin
            if Last <> $FFFF then
              MsgDb.Done;
            if not MsgDb.Open(emh.Conference, False) then
              LogFatalError('Error opening conference '+Long2Str(emh.Conference), IsamError);
            Last := emh.Conference;
          end;
        case emh.What of
          emwAddMsg:
            MsgDb.AddMsg(RefNr, emh.Msg, MsgText);
          emwMarkMsgRead:
            begin
              refnr := MsgDb.FindMsg(emh.Msg.MsgNumber);
              if IsamOk then begin
                MsgDb.GetMsgHeader(refnr, emh.Msg);
                if not FlagIsSet(emh.Msg.mFlags, mfReceived) then begin
                  SetFlag(emh.Msg.mFlags, mfReceived);
                  ClearFlag(emh.Msg.mFlags, mfReceipt);
                  MsgDb.MarkMsgRead(emh.Msg);
                end;
              end;
            end;
        else
          LogFatalError('Error in EXMsgBase tag: '+Long2Str(Ord(emh.What)), 0);
        end;
      end;

    if Last <> $FFFF then
      MsgDb.Done;
    Dispose(MsgText);
    Erase(MsgFile);
  end;

end.